/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.utilities.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public final class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class.getName());

    private HttpUtils() {
    }

    public static String getFileName(HttpMethod method) {
        Header disposition = method.getResponseHeader("Content-Disposition");
        if (disposition != null) {
            String s;
            String value = disposition.getValue();
            String lowercasedValue = value.toLowerCase(Locale.ENGLISH);
            if (!lowercasedValue.contains("attachment") && !lowercasedValue.contains("inline")) {
                return null;
            }
            String str = "filename==?";
            int index = lowercasedValue.indexOf(str);
            if (index >= 0 && !(s = value.substring(index + str.length() - 2)).isEmpty()) {
                try {
                    return new BCodec().decode(s);
                }
                catch (DecoderException e) {
                    logger.warning("BCodec - Unsupported encoding or decoder failed");
                }
            }
            str = "filename=";
            String lowercased = value.toLowerCase();
            index = lowercased.lastIndexOf(str);
            if (index >= 0) {
                String s2 = value.substring(index + str.length());
                int secondQuoteIndex = s2.lastIndexOf(34);
                if (s2.startsWith("\"") && secondQuoteIndex > 0) {
                    s2 = s2.substring(1, secondQuoteIndex);
                }
                if (s2.matches(".*%[0-9A-Fa-f]+.*")) {
                    try {
                        s2 = URLDecoder.decode(s2, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warning("Unsupported encoding");
                    }
                    catch (IllegalArgumentException e) {
                        logger.warning("Invalid file name header: " + e.getMessage());
                        return s2;
                    }
                }
                return s2;
            }
            str = "filename\\*=utf-8''";
            index = lowercased.lastIndexOf(str);
            if (index == -1) {
                str = "filename*=utf-8''";
                index = lowercased.lastIndexOf(str);
            }
            if (index >= 0) {
                String s3 = value.substring(index + str.length());
                if (!s3.isEmpty()) {
                    try {
                        return URLDecoder.decode(s3, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warning("Unsupported encoding");
                    }
                    catch (IllegalArgumentException e) {
                        logger.warning("Invalid file name header: " + e.getMessage());
                        return s3;
                    }
                }
            } else {
                logger.warning("File name was not found in " + value);
            }
        }
        return null;
    }

    public static String replaceInvalidCharsForFileSystem(String fileName, String replaceString) {
        String result;
        if (Utils.isWindows()) {
            result = fileName.replaceAll("[<>:\"/\\\\\\|\\?\\*\\uFFFD[\\u0000-\\u001F]]", replaceString);
            result = result.replaceAll("\\.+$", "");
            result = result.replaceFirst("(?i)^(CON|PRN|AUX|NUL|COM\\d|LPT\\d)(\\..*)?$", "$1" + replaceString + "$2");
        } else {
            result = fileName.replaceAll("[/\\uFFFD]", replaceString);
            if (result.matches("\\.+")) {
                result = "";
            }
        }
        if (result.isEmpty()) {
            return replaceString;
        }
        return result;
    }
}

