/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import com.jgoodies.forms.layout.ColumnSpec;
import cz.vity.freerapid.swing.components.EditorPaneLinkDetector;
import cz.vity.freerapid.swing.components.EditorPaneProxyDetector;
import cz.vity.freerapid.swing.components.PopdownButton;
import cz.vity.freerapid.swing.models.NaiiveComboModel;
import cz.vity.freerapid.swing.renderers.ComboBoxRenderer;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;

public class ComponentFactory {
    private FocusListener focusListener = new SelectAllOnFocusListener();
    private static ComponentFactory instance;
    public static final ColumnSpec DATEPICKER_COLUMN_SPEC;
    public static final ColumnSpec BUTTON_COLSPEC;

    private static synchronized ComponentFactory getInstance() {
        if (instance == null) {
            instance = new ComponentFactory();
        }
        return instance;
    }

    private ComponentFactory() {
    }

    private FocusListener getFocusListener() {
        return this.focusListener;
    }

    public static JSpinner getTimeSpinner() {
        JSpinner spinner = new JSpinner(new SpinnerDateModel());
        ((JSpinner.DateEditor)spinner.getEditor()).getTextField().setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(DateFormat.getTimeInstance(3))));
        return spinner;
    }

    public static JComboBox getComboBox() {
        JComboBox combo = new JComboBox(new NaiiveComboModel());
        combo.setRenderer(new ComboBoxRenderer());
        return combo;
    }

    public static JTextArea getTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return textArea;
    }

    public static JTextField getTextField() {
        JTextField field = new JTextField();
        field.addFocusListener(ComponentFactory.getInstance().getFocusListener());
        return field;
    }

    public static JButton getToolbarButton() {
        JButton btn = new JButton();
        btn.setFocusable(false);
        btn.setPreferredSize(new Dimension(26, 23));
        btn.setMinimumSize(btn.getPreferredSize());
        return btn;
    }

    public static JToggleButton getToolbarToggleButton() {
        JToggleButton btn = new JToggleButton();
        btn.setFocusable(false);
        btn.setPreferredSize(new Dimension(26, 23));
        btn.setMinimumSize(btn.getPreferredSize());
        return btn;
    }

    public static JPasswordField getPasswordField() {
        JPasswordField field = new JPasswordField();
        field.addFocusListener(ComponentFactory.getInstance().getFocusListener());
        return field;
    }

    public static EditorPaneLinkDetector getURLsEditorPane() {
        return new EditorPaneLinkDetector();
    }

    public static EditorPaneProxyDetector getProxiesEditorPane() {
        return new EditorPaneProxyDetector();
    }

    public static PopdownButton getPopdownButton() {
        return new PopdownButton();
    }

    static {
        DATEPICKER_COLUMN_SPEC = ColumnSpec.decode("max(pref;65dlu)");
        BUTTON_COLSPEC = ColumnSpec.decode("max(pref;42dlu)");
    }

    public static final class SelectAllOnFocusListener
    implements FocusListener {
        @Override
        public final void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                ((JTextComponent)e.getComponent()).selectAll();
            }
        }

        @Override
        public final void focusLost(FocusEvent e) {
        }
    }
}

