/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class EditorPaneProxyDetector
extends JEditorPane {
    private static final Logger logger = Logger.getLogger(EditorPaneProxyDetector.class.getName());
    private static final String EXAMPLE = "";
    private static final Pattern REGEXP_URL = Pattern.compile("(?i)^(\\$SOCKS\\$|SOCKS\\:)?((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
    private static final Pattern PROXY_REGEX_PATTERN = Pattern.compile("((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
    private static final Pattern SOCKS_REGEX_PATTERN = Pattern.compile("(?i)^(\\$SOCKS\\$|SOCKS\\:)");

    public EditorPaneProxyDetector() {
        Action copyAction = this.getActionMap().get("copy");
        Action pasteAction = this.getActionMap().get("paste");
        this.getInputMap().put(SwingUtils.getShiftKeyStroke(155), pasteAction);
        this.getInputMap().put(SwingUtils.getCtrlKeyStroke(155), copyAction);
        final SyntaxDocument doc = new SyntaxDocument();
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return doc;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    if (EditorPaneProxyDetector.this.isEditable()) {
                        EditorPaneProxyDetector.this.setEditable(false);
                    }
                } else if (!EditorPaneProxyDetector.this.isEditable()) {
                    EditorPaneProxyDetector.this.setEditable(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    EditorPaneProxyDetector.this.setEditable(true);
                }
            }
        });
        this.insertExampleProxy(doc);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextComponent source = (JTextComponent)e.getSource();
                if (EditorPaneProxyDetector.EXAMPLE.equals(source.getText())) {
                    source.setText(EditorPaneProxyDetector.EXAMPLE);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextComponent source = (JTextComponent)e.getSource();
                if (source.getText().length() <= 0) {
                    EditorPaneProxyDetector.this.insertExampleProxy((StyledDocument)source.getDocument());
                }
            }
        });
    }

    private void insertExampleProxy(StyledDocument doc) {
        SimpleAttributeSet example = new SimpleAttributeSet();
        StyleConstants.setForeground(example, Color.GRAY);
        try {
            doc.insertString(0, EXAMPLE, example);
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
        }
    }

    public void setProxies(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        Document document = this.getDocument();
        String s = EXAMPLE;
        try {
            s = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StringBuilder builder = new StringBuilder();
        s = s.trim();
        builder.append(s);
        if (s.length() > 0) {
            builder.append('\n');
        }
        for (String item : list) {
            builder.append(item).append('\n');
        }
        String str = builder.toString();
        try {
            this.setText(EXAMPLE);
            document.insertString(0, str, null);
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
        }
    }

    public void setProxies(String s) {
        Pattern pattern = REGEXP_URL;
        Matcher matcher = pattern.matcher(s);
        ArrayList<String> list = new ArrayList<String>();
        while (this.validateProxy(s)) {
            String e = matcher.group();
            if (EXAMPLE.equals(e)) continue;
            list.add(e);
        }
        this.setProxies(list);
    }

    public List<String> getProxies() {
        String s = this.getText();
        String[] proxies = s.split("\n|\t|(?:  )");
        ArrayList<String> proxySet = new ArrayList<String>(proxies.length);
        for (String proxy : proxies) {
            if (proxy.trim().isEmpty() || !this.validateProxy(proxy)) continue;
            proxySet.add(proxy);
        }
        return proxySet;
    }

    private boolean validateProxy(String strProxy) {
        Matcher matcherSocks = SOCKS_REGEX_PATTERN.matcher(strProxy);
        if (matcherSocks.find()) {
            strProxy = strProxy.substring(matcherSocks.group(1).length());
        }
        Matcher matcher = PROXY_REGEX_PATTERN.matcher(strProxy);
        return matcher.matches();
    }

    class SyntaxDocument
    extends DefaultStyledDocument {
        private DefaultStyledDocument doc = this;
        private Element rootElement = this.doc.getDefaultRootElement();
        private MutableAttributeSet normal;
        private MutableAttributeSet keyword;
        private static final String DELIMITERS = "\n\t";

        public SyntaxDocument() {
            this.putProperty("__EndOfLine__", "\n");
            this.normal = new SimpleAttributeSet();
            StyleConstants.setForeground(this.normal, Color.RED);
            this.keyword = new SimpleAttributeSet();
            StyleConstants.setForeground(this.keyword, Color.BLUE);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
            if (str.equals(EditorPaneProxyDetector.EXAMPLE)) {
                return;
            }
            this.processChangedLines(offset, str.length());
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            super.remove(offset, length);
            this.processChangedLines(offset, 0);
        }

        public void processChangedLines(int offset, int length) throws BadLocationException {
            String content = this.doc.getText(0, this.doc.getLength());
            int startLine = this.rootElement.getElementIndex(offset);
            int endLine = this.rootElement.getElementIndex(offset + length);
            for (int i = startLine; i <= endLine; ++i) {
                this.applyHighlighting(content, i);
            }
        }

        private void applyHighlighting(String content, int line) throws BadLocationException {
            int startOffset = this.rootElement.getElement(line).getStartOffset();
            int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
            int lineLength = endOffset - startOffset;
            int contentLength = content.length();
            if (endOffset >= contentLength) {
                endOffset = contentLength - 1;
            }
            this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
            this.checkForTokens(content, startOffset, endOffset);
        }

        private void checkForTokens(String content, int startOffset, int endOffset) {
            while (startOffset <= endOffset) {
                while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                    if (startOffset < endOffset) {
                        ++startOffset;
                        continue;
                    }
                    return;
                }
                startOffset = this.getOtherToken(content, startOffset, endOffset);
            }
        }

        private int getOtherToken(String content, int startOffset, int endOffset) {
            int endOfToken;
            for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
            }
            String token = content.substring(startOffset, endOfToken);
            if (this.isKeyword(token)) {
                this.keyword.addAttribute("PROXY", token);
                this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword, false);
            }
            return endOfToken + 1;
        }

        protected boolean isDelimiter(String character) {
            return DELIMITERS.indexOf(character.charAt(0)) != -1;
        }

        protected boolean isKeyword(String token) {
            return EditorPaneProxyDetector.this.validateProxy(token);
        }
    }
}

