/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final int WINDOWS_OS = 0;
    private static int operatingSystem = -1;
    private static String actualJavaVersion = null;
    private static final int XOR_VALUE = 35132;
    public static volatile String appPath = null;

    private Utils() {
    }

    public static String generateXorString(String text) {
        if (text == null) {
            return null;
        }
        char[] textArray = text.toCharArray();
        int length = textArray.length;
        if (length > 0) {
            StringBuilder buffer = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                buffer.append((char)(textArray[i] ^ 0x893C));
            }
            return buffer.toString();
        }
        return "";
    }

    public static boolean isJVMVersion(double requiredVersion) {
        Double actualVersion;
        if (actualJavaVersion == null) {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion == null) {
                return false;
            }
            actualJavaVersion = javaVersion.substring(0, 3);
        }
        return (actualVersion = new Double(actualJavaVersion)).compareTo(requiredVersion) >= 0;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getPureFilename(File f) {
        String[] fileName = f.getName().split("\\.", 2);
        return fileName[0];
    }

    public static String getPureFilenameWithDots(File f) {
        String s = f.getName();
        int index = s.lastIndexOf(46);
        if (index > 0) {
            return s.substring(0, index);
        }
        return s;
    }

    public static String addFileSeparator(String filePath) {
        return filePath.endsWith(File.separator) ? filePath : filePath + File.separator;
    }

    public static String shortenFileName(File file) {
        return Utils.shortenFileName(file.getAbsolutePath());
    }

    public static String shortenFileName(File file, int lengthLimit) {
        return Utils.shortenFileName(file.getAbsolutePath(), lengthLimit);
    }

    public static String shortenFileName(String text) {
        return Utils.shortenFileName(text, 60);
    }

    public static String shortenFileName(String text, int lengthLimit) {
        int textLength = text.length();
        if (textLength < lengthLimit) {
            return text;
        }
        String fileSeparator = File.separator;
        String[] separated = text.split(fileSeparator.equals("\\") ? "\\\\" : fileSeparator);
        int separatedCount = separated.length;
        if (separatedCount > 3) {
            int wouldDelete = 0;
            for (int extractIndex = 2; extractIndex < separatedCount - 2 && textLength - (wouldDelete += separated[extractIndex].length()) + 3 >= lengthLimit; ++extractIndex) {
            }
            StringBuilder result = new StringBuilder(textLength - wouldDelete + 3);
            result.append(separated[0]).append(fileSeparator).append(separated[1]).append(fileSeparator).append("...");
            for (int i = extractIndex + 1; i < separatedCount; ++i) {
                result.append(fileSeparator);
                result.append(separated[i]);
            }
            return result.toString();
        }
        return text;
    }

    public static void addParam(StringBuilder params, String paramName, String paramValue) {
        String encoded;
        if (paramValue == null) {
            paramValue = "";
        }
        try {
            encoded = URLEncoder.encode(paramValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encoded = "";
            LogUtils.processException(logger, e);
        }
        if (params.length() > 0) {
            params.append('&');
        }
        params.append(paramName).append('=').append(encoded);
    }

    public static boolean isWindows() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = osName == null || osName.startsWith("Windows") ? 0 : 1;
        }
        return operatingSystem == 0;
    }

    public static void setFileAsHidden(File file) {
        if (!file.exists() || !file.isFile()) {
            return;
        }
        if (Utils.isWindows()) {
            try {
                Runtime.getRuntime().exec("attrib.exe +H " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warning("Setting file " + file.getAbsolutePath() + " as hidden failed.");
                LogUtils.processException(logger, e);
            }
        } else {
            File newFile;
            String s = file.getName();
            if (!s.startsWith(".") && !file.renameTo(newFile = new File(file.getParentFile(), "." + s))) {
                logger.warning("Setting file " + file.getAbsolutePath() + " as hidden failed.");
            }
        }
    }

    public static Properties loadProperties(String propertiesFile, boolean isResource) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            InputStream inputStream2 = inputStream = !isResource ? new FileInputStream(propertiesFile) : Utils.class.getClassLoader().getResourceAsStream(propertiesFile);
            if (inputStream == null) {
                throw new IOException("Couldn't read Properties file");
            }
            props.load(inputStream);
            inputStream.close();
            return props;
        }
        catch (IOException e) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                LogUtils.processException(logger, ex);
            }
            logger.warning("Couldn't load properties:" + propertiesFile);
            return props;
        }
    }

    public static String addParam(String params, String paramName, String paramValue) {
        String encoded;
        try {
            encoded = URLEncoder.encode(paramValue, "ISO-8859-2");
        }
        catch (UnsupportedEncodingException e) {
            encoded = "";
            LogUtils.processException(logger, e);
        }
        String paramWithValue = paramName + "=" + encoded;
        return params.length() > 0 ? params + "&" + paramWithValue : paramWithValue;
    }

    public static boolean hasValue(String string) {
        return string != null && !string.isEmpty();
    }

    public static String getExceptionMessage(Throwable cause) {
        String message = cause.getLocalizedMessage();
        if (message == null) {
            message = cause.getMessage() != null ? cause.getMessage() : cause.toString();
        }
        return message;
    }

    public static String loadFile(String fileName) {
        return Utils.loadFile(new File(fileName), null);
    }

    public static String loadFile(File file) {
        return Utils.loadFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(File file, String encoding) {
        StringBuilder buffer = new StringBuilder(2000);
        BufferedReader stream = null;
        try {
            int read;
            InputStreamReader inputStreamReader = encoding == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            stream = new BufferedReader(inputStreamReader);
            char[] lines = new char[2000];
            while ((read = stream.read(lines)) != -1) {
                buffer.append(lines, 0, read);
            }
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
        return buffer.toString();
    }

    public static String getAppPath() {
        if (appPath != null) {
            return appPath;
        }
        try {
            URI uri = LogUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                logger.info("Running Webstart application");
                appPath = "";
                return "";
            }
            appPath = new File(uri).getParent();
        }
        catch (URISyntaxException e) {
            LogUtils.processException(logger, e);
            appPath = "";
            return "";
        }
        logger.config("App Path is " + appPath);
        return appPath;
    }

    public static String getSystemLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static String getApplicationArguments() {
        Properties properties = System.getProperties();
        if (properties.containsKey("arguments")) {
            String[] strings = (String[])properties.get("arguments");
            StringBuilder builder = new StringBuilder();
            for (String s : strings) {
                builder.append(s).append(' ');
            }
            return builder.toString().trim();
        }
        return "";
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    public static String urlDecode(String s) {
        try {
            String decoded = URLDecoder.decode(s, "UTF-8");
            if (decoded.contains("\ufffd")) {
                decoded = URLDecoder.decode(s, "Windows-1250");
            }
            if (decoded.contains("\ufffd")) {
                return s;
            }
            return decoded;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static URI convertToURI(String url) throws URISyntaxException, URIException {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            uri = new URI(URIUtil.encodePathQuery(url));
        }
        return uri;
    }

    public static String reverseString(String string) {
        return new StringBuilder(string).reverse().toString();
    }

    public static String getThrowableDescription(Throwable t) {
        String s = t.getClass().getSimpleName();
        String l = t.getLocalizedMessage();
        if (l == null) {
            return s;
        }
        return s + ": " + l;
    }

    public static String dumpStackTraces() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Throwable throwable = new Throwable(){

            @Override
            public String toString() {
                return "";
            }
        };
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElements = entry.getValue();
            throwable.setStackTrace(stackTraceElements);
            Thread thread = entry.getKey();
            printWriter.append(String.valueOf(thread)).append(" [").append(String.valueOf((Object)thread.getState())).append(']').append(Utils.getSystemLineSeparator());
            throwable.printStackTrace(printWriter);
            printWriter.append(Utils.getSystemLineSeparator());
        }
        return writer.toString();
    }

    private static void removeCryptographyRestrictions() {
        if (!Utils.isRestrictedCryptography()) {
            logger.fine("Cryptography restrictions removal not needed");
            return;
        }
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
            isRestrictedField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
            isRestrictedField.set(null, false);
            Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicyField.setAccessible(true);
            PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
            Field perms = cryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            ((Map)perms.get(defaultPolicy)).clear();
            Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            defaultPolicy.add((Permission)instance.get(null));
            logger.fine("Successfully removed cryptography restrictions");
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to remove cryptography restrictions", e);
        }
    }

    private static boolean isRestrictedCryptography() {
        String name = System.getProperty("java.runtime.name");
        String ver = System.getProperty("java.version");
        return name != null && name.equals("Java(TM) SE Runtime Environment") && ver != null && (ver.startsWith("1.7") || ver.startsWith("1.8"));
    }

    static {
        Utils.removeCryptographyRestrictions();
    }
}

