/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.AbstractSystemCommander;
import cz.vity.freerapid.utilities.os.OSCommand;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

class UnixCommander
extends AbstractSystemCommander {
    private static final String SYSTEM_COMMAND_PROPERTIES_FILE = "syscmd.properties";
    private static final Logger logger = Logger.getLogger(UnixCommander.class.getName());
    private Properties commands;

    UnixCommander(File homeDirectory) {
        if (System.getProperty("javax.net.ssl.trustStore", "").startsWith("/etc/ssl/")) {
            logger.warning("Possible SSL problem, javax.net.ssl.trustStore points to directory requiring higher access rights. Trying workaround.");
            System.setProperty("javax.net.ssl.trustStore", System.getProperty("java.io.tmpdir", " "));
        }
        this.init(homeDirectory);
    }

    private void init(File homeDirectory) {
        File file = new File(homeDirectory, SYSTEM_COMMAND_PROPERTIES_FILE);
        this.commands = file.isFile() && file.exists() ? Utils.loadProperties(file.getAbsolutePath(), false) : ((file = new File(Utils.getAppPath(), SYSTEM_COMMAND_PROPERTIES_FILE)).isFile() && file.exists() ? Utils.loadProperties(file.getAbsolutePath(), false) : new Properties());
    }

    @Override
    public boolean createShortCut(OSCommand shortCutCommand) {
        if (!OSCommand.shortCutCommands.contains((Object)shortCutCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)shortCutCommand) + " is not a shortcut command");
        }
        switch (shortCutCommand) {
            case CREATE_DESKTOP_SHORTCUT: {
                return this.createDesktopShortcut();
            }
            case CREATE_QUICKLAUNCH_SHORTCUT: {
                return this.createQuickLaunchShortcut();
            }
            case CREATE_STARTMENU_SHORTCUT: {
                return this.createStartMenuShortcut();
            }
            case CREATE_STARTUP_SHORTCUT: {
                return this.createStartupShortcut();
            }
        }
        assert (false);
        return false;
    }

    private boolean createDesktopShortcut() {
        return this.makeShortcut(OSCommand.CREATE_DESKTOP_SHORTCUT);
    }

    private boolean makeShortcut(OSCommand type) {
        return this.isSupported(type) && UnixCommander.runCommand(this.getCommand(type), true);
    }

    private static String prepareCommand(String cmd) {
        String appPath = Utils.getAppPath();
        String appPathSep = Utils.addFileSeparator(appPath);
        cmd = cmd.replaceAll("%DIR%", appPath);
        cmd = cmd.replaceAll("%VERSION%", "1.0beta");
        cmd = cmd.replaceAll("%APPVERSION%", "FreeRapid 1.0beta");
        cmd = cmd.replaceAll("%AUTHORS%", "DevTeam (c) 2008-2017");
        cmd = cmd.replaceAll("%PRODUCT%", "FreeRapid");
        cmd = cmd.replaceAll("%ICON_PATH%", appPathSep + "frd.png");
        cmd = cmd.replaceAll("%SH_SCRIPT_PATH%", appPathSep + "frd.sh");
        cmd = cmd.replaceAll("%ARGS%", Utils.getApplicationArguments());
        return cmd;
    }

    private static boolean runCommand(String cmd, boolean waitForResult) {
        cmd = UnixCommander.prepareCommand(cmd);
        logger.info("Xcommand:" + cmd);
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            if (waitForResult) {
                process.waitFor();
                return process.exitValue() == 0;
            }
            return true;
        }
        catch (IOException e) {
            logger.warning("XCommand command:" + cmd);
            LogUtils.processException(logger, e);
            return false;
        }
        catch (InterruptedException e) {
            LogUtils.processException(logger, e);
            return false;
        }
    }

    private boolean createStartMenuShortcut() {
        return this.makeShortcut(OSCommand.CREATE_STARTMENU_SHORTCUT);
    }

    private boolean createStartupShortcut() {
        return this.makeShortcut(OSCommand.CREATE_STARTUP_SHORTCUT);
    }

    private boolean createQuickLaunchShortcut() {
        return this.makeShortcut(OSCommand.CREATE_QUICKLAUNCH_SHORTCUT);
    }

    @Override
    public boolean shutDown(OSCommand shutDownCommand, boolean force) {
        if (!OSCommand.shutDownCommands.contains((Object)shutDownCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)shutDownCommand) + " is not a shut down command");
        }
        return this.isSupported(shutDownCommand) && UnixCommander.runCommand(this.getCommand(shutDownCommand), false);
    }

    @Override
    public boolean isSupported(OSCommand command) {
        String cmd = UnixCommander.getKey(command);
        return this.commands.containsKey(cmd) && !this.commands.getProperty(cmd, "").trim().isEmpty();
    }

    private String getCommand(OSCommand command) {
        return this.commands.getProperty(UnixCommander.getKey(command), "");
    }

    private static String getKey(OSCommand command) {
        return command.toString().toLowerCase();
    }

    @Override
    public boolean findTopLevelWindow(String stringToFind, boolean caseSensitive) throws IOException {
        String command = this.getCommand(OSCommand.LIST_TOP_WINDOWS);
        return super.findTopLevelWndow(stringToFind, caseSensitive, command);
    }

    @Override
    public List<String> getTopLevelWindowsList() throws IOException {
        String command = this.getCommand(OSCommand.LIST_TOP_WINDOWS);
        return super.getTopLevelWindowsList(command);
    }

    @Override
    public void preventSystemStandby(boolean prevent) {
    }
}

