/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class SingleFiledLayout
implements LayoutManager,
Serializable {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int DEFAULT_GAP = 5;
    protected final int orientation;
    protected final int justification;
    protected final int gap;

    public SingleFiledLayout() {
        this(0, 0, 5);
    }

    public SingleFiledLayout(int n) {
        this(n, 0, 5);
    }

    public SingleFiledLayout(int n, int n2, int n3) {
        if (n != 1) {
            n = 0;
        }
        if (n2 != 1 && n2 != 2 && n2 != 4) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.orientation = n;
        this.justification = n2;
        this.gap = n3;
    }

    public final void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (Component component : componentArray) {
                Dimension dimension2 = component.getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n = insets.left;
                        break;
                    }
                    case 1: {
                        n = (dimension.width - dimension2.width >> 1) + insets.left - insets.right;
                        break;
                    }
                    case 2: {
                        n = insets.left;
                        dimension2.width = dimension.width - insets.left - insets.right;
                        break;
                    }
                    case 4: {
                        n = dimension.width - dimension2.width - insets.right;
                    }
                }
                component.setBounds(n, n2, dimension2.width, dimension2.height);
                n2 += dimension2.height + this.gap;
            }
        } else {
            for (Component component : componentArray) {
                Dimension dimension3 = component.getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n2 = insets.top;
                        break;
                    }
                    case 1: {
                        n2 = (dimension.height - dimension3.height >> 1) + insets.top - insets.bottom;
                        break;
                    }
                    case 2: {
                        n2 = insets.top;
                        dimension3.height = dimension.height - insets.top - insets.bottom;
                        break;
                    }
                    case 3: {
                        n2 = dimension.height - dimension3.height - insets.bottom;
                    }
                }
                component.setBounds(n, n2, dimension3.width, dimension3.height);
                n += dimension3.width + this.gap;
            }
        }
    }

    public final Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (Component component : componentArray) {
                Dimension dimension = component.getPreferredSize();
                if (n < dimension.width) {
                    n = dimension.width;
                }
                n2 += dimension.height + this.gap;
            }
            n2 -= this.gap;
        } else {
            for (Component component : componentArray) {
                Dimension dimension = component.getPreferredSize();
                n += dimension.width + this.gap;
                if (n2 >= dimension.height) continue;
                n2 = dimension.height;
            }
            n -= this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public final Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (Component component : componentArray) {
                Dimension dimension = component.getMinimumSize();
                if (n < dimension.width) {
                    n = dimension.width;
                }
                n2 += dimension.height + this.gap;
            }
            n2 -= this.gap;
        } else {
            for (Component component : componentArray) {
                Dimension dimension = component.getMinimumSize();
                n += dimension.width + this.gap;
                if (n2 >= dimension.height) continue;
                n2 = dimension.height;
            }
            n = -this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public final void addLayoutComponent(String string, Component component) {
    }

    public final void removeLayoutComponent(Component component) {
    }
}

