/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Utils;

public final class AppPrefs {
    private static final Logger logger = Logger.getLogger(AppPrefs.class.getName());
    private static final String DEFAULT_PROPERTIES = "damaq.properties";
    private static final String USER_PROPERTIES_WINDOWS = "Application Data\\Damaq\\damaq.properties";
    private static final String USER_PROPERTIES_MACOS = "Library/Preferences/damaq.properties";
    private static final String USER_PROPERTIES_LINUX = ".damaq.properties";
    private static final String CLASS_EXT = ".class";
    private static final String JAR_SEPARATOR = "damaq.jar!/";
    private static final String URL_SEPARATOR = "/";
    private static final String CLASS_SEPARATOR = ".";
    private static final String FILE_PREFIX = "file:";
    private static volatile String appPath = null;
    private static volatile String propertiesFile = null;
    private static volatile Properties properties = AppPrefs.loadDefaultProperties();
    public static final String PROXY_USE = "proxy";
    public static final String PROXY_URL = "proxy.url";
    public static final String PROXY_SAVEPASSWORD = "proxy.savepassword";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_LOGIN = "proxy.login";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String ONEINSTANCE = "oneinstance";
    public static final String WINDOWSPOSITION = "position";
    public static final String WINDOWSPOSITION_WIDTH = "posW";
    public static final String WINDOWSPOSITION_HEIGHT = "posH";
    public static final String WINDOWSPOSITION_MAXIMIZED = "posMax";
    public static final String WINDOWSPOSITION_X = "posX";
    public static final String WINDOWSPOSITION_Y = "posY";
    public static final String MAX_RECENT_FILES = "recentcount";
    public static final String NEW_VERSION = "newversion";
    public static final String DRAG_AND_DROP = "dragndrop";
    public static final String LAST_USED_OPENFILTER = "openfilter";
    public static final String LAST_USED_SAVEFILTER = "savefilter";
    public static final String DECORATED_FRAMES = "decorated";
    public static final String DEFAULT_FOLDER = "defaultFolder";
    public static final String SHOW_STATUSBAR = "showstatusbar";
    public static final String BOARD_NUMBERS = "board.numbers";
    public static final String REVERSED_VIEW = "board.reversedView";
    public static final String ZOOM_VIEW = "board.zoomView";
    public static final String ACTIVE_SKIN = "activeSkin";
    public static final String LONG_MOVES = "longMoves";
    public static final String LONG_MOVES_HISTORY = "longMovesHistory";
    public static final String SAME_MOVES = "sameMoves";
    public static final String SHOW_COMMENTS = "showComments";
    public static final String LEVEL = "level";
    public static final String LASTOPENFOLDER_KEY = "lastOpenFolder";
    public static final String PREVIOUS_EVENTS = "prevEvents";
    public static final String PREVIOUS_SITE = "prevSite";
    public static final String PREVIOUS_WHITE = "prevWhite";
    public static final String PREVIOUS_BLACK = "prevBlack";
    public static final String SHOW_INFOTABLE = "showinfotable";
    public static final String INFO_SUCCESFUL = "infoSuccesful";
    public static final String LASTFILENAME = "lastFileName";
    public static final String APPEND_GAME_TO_END = "appendGameToEnd";
    public static final String LONG_MOVES_PDN = "longMovesPDN";
    public static final String OPEN_SIMPLEPDN_FAST = "openSimplePDNFast";
    public static final String PLAY_SOUND = "playSound";
    public static final String ASK_WHEN_NEW = "askWhenNew";
    public static final String ASK_WHEN_EXIT = "askWhenExit";
    public static final String VISIBLE_TOOLBARS = "visibleToolbars";
    public static final String EXWHITE_BAR = "exWhiteBar";
    public static final String EXBLACK_BAR = "exBlackBar";
    public static final String EXWHITE_KING = "exWhiteKing";
    public static final String EXBLACK_KING = "exBlackKing";
    public static final String EXWHITE_PIECE = "exWhitePiece";
    public static final String EXBLACK_PIECE = "exBlackPiece";
    public static final String PDN_CHARSET = "pdnCharset";
    public static final String SHOW_TOOLBAR = "showToolbar";

    private AppPrefs() {
    }

    private static synchronized Properties loadDefaultProperties() {
        String string = System.getProperty("os.name");
        String string2 = string == null || string.startsWith("Windows") ? USER_PROPERTIES_WINDOWS : (string.startsWith("Linux") ? USER_PROPERTIES_LINUX : (string.startsWith("Mac") ? USER_PROPERTIES_MACOS : USER_PROPERTIES_WINDOWS));
        propertiesFile = System.getProperty("user.home") + File.separator + string2;
        File file = new File(propertiesFile);
        String string3 = !file.exists() ? new StringBuilder(35).append(AppPrefs.getAppPath()).append(File.separator).append(DEFAULT_PROPERTIES).toString() : propertiesFile;
        properties = Utils.loadProperties(string3, false);
        return properties;
    }

    public static int getProperty(String string, int n) {
        try {
            return Integer.parseInt(properties.getProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static boolean getProperty(String string, boolean bl) {
        String string2 = properties.getProperty(string, String.valueOf(bl));
        return Boolean.valueOf(string2);
    }

    public static void removeProperty(String string) {
        properties.remove(string);
    }

    public static void store() {
        if (!AppPrefs.getProperty(PROXY_SAVEPASSWORD, false)) {
            properties.remove(PROXY_PASSWORD);
        }
        OutputStream outputStream = null;
        try {
            File file;
            File file2 = new File(propertiesFile);
            if (!file2.exists() && (file = file2.getParentFile()) != null) {
                file.mkdirs();
            }
            outputStream = new FileOutputStream(file2);
            properties.store(outputStream, "Damaq 1.01" + System.getProperty("line.separator", "\n") + "#Damaq properties. Only for experienced users.");
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException2) {
                LogUtils.processException(logger, iOException2);
            }
            logger.severe("Couldn't save app properties. This is a fatal error. Please reinstall the application.");
            LogUtils.processException(logger, iOException);
        }
        logger.info("Properties were saved successfuly");
    }

    public static String getAppPath() {
        if (appPath != null) {
            return appPath;
        }
        String string = Utils.class.getName();
        int n = string.length() + CLASS_EXT.length();
        int n2 = string.lastIndexOf(CLASS_SEPARATOR);
        boolean bl = logger.isLoggable(Level.INFO);
        if (n2 > -1) {
            string = string.substring(n2 + 1);
        }
        if (bl) {
            logger.config("ClassName " + string + CLASS_EXT);
        }
        URL uRL = Utils.class.getResource(string + CLASS_EXT);
        if (bl) {
            logger.config("URL " + uRL);
        }
        if (uRL != null) {
            int n3;
            String string2 = uRL.toString();
            if (bl) {
                logger.config("Url string1 " + string2);
            }
            if ((n2 = string2.lastIndexOf(JAR_SEPARATOR)) > -1) {
                string2 = string2.substring(0, n2);
                if (bl) {
                    logger.config("URL String2 " + string2);
                }
                n3 = string2.lastIndexOf(URL_SEPARATOR) + 1;
            } else {
                n3 = string2.length() - n;
            }
            n2 = string2.lastIndexOf(FILE_PREFIX);
            n2 = n2 > -1 ? (n2 += FILE_PREFIX.length() + (Utils.isWindows() ? 1 : 0)) : 0;
            string2 = string2.substring(n2, n3);
            if (logger.isLoggable(Level.INFO)) {
                logger.config("App Path is " + string2);
            }
            String string3 = "";
            try {
                string3 = URLDecoder.decode(string2, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogUtils.processException(logger, unsupportedEncodingException);
            }
            appPath = string3;
            return appPath;
        }
        return "";
    }

    public static void storeProperty(String string, boolean bl) {
        properties.setProperty(string, String.valueOf(bl));
    }

    public static void storeProperty(String string, String string2, boolean bl) {
        properties.setProperty(string, string2);
        if (bl) {
            AppPrefs.store();
        }
    }

    public static void storeProperty(String string, String string2) {
        properties.setProperty(string, string2);
    }

    public static void storeProperty(String string, int n) {
        properties.setProperty(string, String.valueOf(n));
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }
}

