/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.damaq.core.AppPrefs;
import net.damaq.core.managers.SupportedLanguage;
import net.damaq.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lng {
    private static final String DEFAULT_LANG_CODE = "EN";
    private static final String DEFAULT_NOT_FOUND = "Not found!";
    private static final String LANG_EXTENSION = ".properties";
    private static final String MNEMONIC_EXTENSION = ".mnemonic";
    private static final String HINT_EXTENSION = ".hint";
    private static List<SupportedLanguage> supportedLanguages = null;
    private static final String SELECTED_LANGUAGE_KEY = "selLanguage";
    private static final String LANG_LIST_FILE = "languages.properties";
    private static final String LANG_NONAME_ICON = "blank.gif";
    private static final String localeLanguageCode = Locale.getDefault().getLanguage().toUpperCase();
    private static Properties properties = Lng.loadLangProperties();

    private Lng() {
    }

    public static List<SupportedLanguage> getSupportedLanguages() {
        if (supportedLanguages == null) {
            String string;
            String string2;
            supportedLanguages = new ArrayList<SupportedLanguage>(4);
            Properties properties = Utils.loadProperties("resources/languages/languages.properties", true);
            int n = -1;
            while ((string2 = properties.getProperty(string = "language" + ++n)) != null) {
                Integer n2 = properties.getProperty(string + MNEMONIC_EXTENSION, "\u0000").charAt(0);
                SupportedLanguage supportedLanguage = new SupportedLanguage(string2, properties.getProperty(string + ".name", "?"), properties.getProperty(string + ".icon", LANG_NONAME_ICON), n2);
                supportedLanguages.add(supportedLanguage);
            }
        }
        return supportedLanguages;
    }

    public static String getSelectedLanguageCode() {
        return AppPrefs.getProperty(SELECTED_LANGUAGE_KEY, DEFAULT_LANG_CODE);
    }

    public static void setSelectedLanguageCode(String string) {
        AppPrefs.storeProperty(SELECTED_LANGUAGE_KEY, string);
    }

    private static Properties loadLangProperties() {
        String string = AppPrefs.getProperty(SELECTED_LANGUAGE_KEY, null);
        if (string == null) {
            string = DEFAULT_LANG_CODE;
            for (SupportedLanguage supportedLanguage : Lng.getSupportedLanguages()) {
                SupportedLanguage supportedLanguage2 = supportedLanguage;
                if (!supportedLanguage2.getLanguageCode().equals(localeLanguageCode)) continue;
                string = supportedLanguage2.getLanguageCode();
                break;
            }
            AppPrefs.storeProperty(SELECTED_LANGUAGE_KEY, string);
        }
        return Utils.loadProperties(new StringBuilder(50).append("resources/languages/").append(string).append(LANG_EXTENSION).toString(), true);
    }

    public static String getLabel(String string) {
        return properties.getProperty(string, DEFAULT_NOT_FOUND);
    }

    public static String getHint(String string) {
        return properties.getProperty(string + HINT_EXTENSION, null);
    }

    public static String getLabel(String string, String string2) {
        return Lng.getLabel(string, new Object[]{string2 == null ? "" : string2});
    }

    public static String getLabel(String string, Object ... objectArray) {
        return new MessageFormat(properties.getProperty(string, DEFAULT_NOT_FOUND)).format(objectArray);
    }

    public static String formatLabel(String string, Object ... objectArray) {
        return new MessageFormat(string).format(objectArray);
    }

    public static String loadAndFormatLabel(String string, Object ... objectArray) {
        return new MessageFormat(Lng.getLabel(string)).format(objectArray);
    }

    public static char getMnemonic(String string) {
        String string2 = properties.getProperty(string + MNEMONIC_EXTENSION, "");
        return string2.length() > 0 ? string2.charAt(0) : (char)'\u0000';
    }

    public static void reloadLangProperties() {
        properties = Lng.loadLangProperties();
    }
}

