/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.util.logging.Logger;
import net.damaq.core.AppPrefs;
import net.damaq.core.MainAppFrame;
import net.damaq.core.OneInstanceClient;
import net.damaq.core.actions.CheckForNewVersion;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Utils;

public final class MainApp {
    private MainAppFrame mainAppFrame;
    private static final MainApp ourInstance = new MainApp();
    private static Logger logger;

    public static void makeProgress() {
        System.out.println("Loading ... please wait");
    }

    public static MainApp getInstance() {
        return ourInstance;
    }

    private MainApp() {
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        if (stringArray.length >= 1) {
            string = stringArray[0];
            if (string.endsWith("?") || string.endsWith("help")) {
                System.out.println("Damaq 1.01");
                System.out.println("created by VitySoft(c)2005 /http://wordrider.net/damaq/");
                System.out.println("usage: dama [-help|-debug] [file]");
                System.out.println("commands: -help  - to view this message");
                System.out.println("          -debug - enable debug log level");
                System.out.println("           file - path to file for opening");
                System.out.println("min. Java version required : 1.5");
                return;
            }
            if (string.endsWith("debug")) {
                bl = true;
                string = stringArray.length > 1 ? stringArray[1] : null;
            }
        }
        LogUtils.initLogging(bl);
        logger = Logger.getLogger(MainApp.class.getName());
        if (OneInstanceClient.checkInstance(string)) {
            return;
        }
        MainApp.getInstance().start(string);
    }

    private void start(String string) {
        if (!Utils.isJVMVersion(1.5)) {
            System.err.println("Whooops. Application requires a 1.5 version or later of the Java platform.");
            System.err.println("Please upgrade to a newer version. Read a readme text file(if you find any ;-) for available URLs.");
            System.exit(-1);
        }
        MainApp.makeProgress();
        this.getMainAppFrame().init(string);
        if (AppPrefs.getProperty("newversion", false)) {
            this.startCheckNewVersion();
        }
    }

    private void startCheckNewVersion() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    CheckForNewVersion.check(false);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public final MainAppFrame getMainAppFrame() {
        if (this.mainAppFrame == null) {
            this.mainAppFrame = new MainAppFrame();
            return this.mainAppFrame;
        }
        return this.mainAppFrame;
    }
}

