/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.awt.BorderLayout;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.actions.ExitAction;
import net.damaq.core.actions.NewGameAction;
import net.damaq.core.actions.OpenFileAction;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.swing.MouseEventQueue;
import net.damaq.gui.LookAndFeels;
import net.damaq.utilities.Swinger;

public final class MainAppFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(MainAppFrame.class.getName());
    private JPanel rootPanel;
    private ManagerDirector mainPanelManager;

    public MainAppFrame() throws HeadlessException {
        int n;
        int n2;
        boolean bl;
        Image image;
        LookAndFeels.getInstance().loadLookAndFeelSettings();
        if (AppPrefs.getProperty("decorated", false)) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
            LookAndFeels.updateWindowUI(this);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        if ((image = Swinger.getIconImage("011.png")) != null) {
            this.setIconImage(image);
        }
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        int n3 = displayMode.getWidth();
        int n4 = displayMode.getHeight();
        int n5 = Math.min(n3, 1024);
        int n6 = Math.min(n4, 768);
        if (AppPrefs.getProperty("position", true) && !AppPrefs.getProperty("posMax", false)) {
            bl = false;
            this.setLocation(AppPrefs.getProperty("posX", 0), AppPrefs.getProperty("posY", 0));
            n2 = AppPrefs.getProperty("posW", n5);
            n = AppPrefs.getProperty("posH", n6);
        } else {
            bl = AppPrefs.getProperty("posMax", false);
            n2 = n5;
            n = n6;
        }
        this.setSize(n2, n);
        this.setTitle("Damaq 1.01" + (logger.isLoggable(Level.INFO) ? " debug" : ""));
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getMainPanel());
        if (bl) {
            this.setExtendedState(6);
        }
    }

    protected final JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainAppFrame.this.mainPanelManager.getStatusbarManager().specialKeyStatusChanged();
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(144, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(20, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public final void init(final String string) {
        String[] stringArray;
        this.getManagerDirector();
        this.mainPanelManager.getDesktopManager().addDrawBoard();
        NewGameAction.getInstance().actionPerformed(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainAppFrame.this.mainPanelManager.getGame().start();
                if (string != null) {
                    OpenFileAction.open(new File(string));
                }
            }
        });
        this.setVisible(true);
        String[] stringArray2 = stringArray = new String[]{"FileChooser.lookInLabelText", "FileChooser.saveInLabelText", "FileChooser.fileNameLabelText", "FileChooser.filesOfTypeLabelMnemonic", "FileChooser.filesOfTypeLabelText", "FileChooser.upFolderToolTipText", "FileChooser.upFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.homeFolderAccessibleName", "FileChooser.newFolderToolTipText", "FileChooser.newFolderAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.listViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.fileNameHeaderText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileAttrHeaderText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "ColorChooser.cancelText", "ColorChooser.hsbBlueText", "ColorChooser.hsbBrightnessText", "ColorChooser.hsbDisplayedMnemonicIndex", "ColorChooser.hsbGreenText", "ColorChooser.hsbHueText", "ColorChooser.hsbMnemonic", "ColorChooser.hsbNameText", "ColorChooser.hsbRedText", "ColorChooser.hsbSaturationText", "ColorChooser.okText", "ColorChooser.previewText", "ColorChooser.resetMnemonic", "ColorChooser.resetText", "ColorChooser.rgbBlueText", "ColorChooser.rgbDisplayedMnemonicIndex", "ColorChooser.rgbGreenText", "ColorChooser.rgbMnemonic", "ColorChooser.rgbNameText", "ColorChooser.rgbRedText", "ColorChooser.sampleText", "ColorChooser.swatchesDisplayedMnemonicIndex", "ColorChooser.swatchesMnemonic", "ColorChooser.swatchesNameText", "ColorChooser.swatchesRecentText"};
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = string2 = stringArray2[i];
            UIManager.put(string3, Lng.getLabel(string3));
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new MouseEventQueue());
    }

    private JPanel getMainPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(new BorderLayout());
        }
        return this.rootPanel;
    }

    public final ManagerDirector getManagerDirector() {
        if (this.mainPanelManager == null) {
            this.mainPanelManager = new ManagerDirector(this, this.rootPanel);
        }
        return this.mainPanelManager;
    }

    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ExitAction.getInstance().actionPerformed(null);
        }
    }
}

