/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Logger;
import net.damaq.core.AppPrefs;
import net.damaq.core.OneInstanceServer;
import net.damaq.utilities.LogUtils;

final class OneInstanceClient {
    private static final Logger logger = Logger.getLogger(OneInstanceClient.class.getName());

    private OneInstanceClient() {
    }

    public static boolean checkInstance(String string) {
        if (!AppPrefs.getProperty("oneinstance", false)) {
            return false;
        }
        try {
            Socket socket;
            block11: {
                socket = new Socket("localhost", 35139);
                logger.info("Application is already running. Exiting");
                if (string != null && string.length() > 0) {
                    OutputStream outputStream = null;
                    try {
                        outputStream = socket.getOutputStream();
                        if (outputStream != null) {
                            outputStream.write(string.getBytes());
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        LogUtils.processException(logger, iOException);
                        if (outputStream == null) break block11;
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            LogUtils.processException(logger, exception);
                        }
                    }
                }
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
                System.exit(-1);
            }
            return true;
        }
        catch (Exception exception) {
            OneInstanceServer oneInstanceServer = new OneInstanceServer();
            oneInstanceServer.start();
            return false;
        }
    }
}

