/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import net.damaq.utilities.LogUtils;

final class OneInstanceServer
extends Thread {
    private static final Logger logger = Logger.getLogger(OneInstanceServer.class.getName());

    public OneInstanceServer() {
        this.setPriority(1);
    }

    public final void run() {
        Socket socket = null;
        try {
            logger.info("Creating a local socket server");
            ServerSocket serverSocket = new ServerSocket(35139, 1);
            while (!this.isInterrupted()) {
                logger.info("Waiting for connection");
                socket = serverSocket.accept();
                logger.info("Got a connection");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                bufferedReader.close();
                socket.close();
            }
        }
        catch (IOException iOException) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    LogUtils.processException(logger, iOException);
                }
            }
            LogUtils.processException(logger, iOException);
        }
    }
}

