/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import net.damaq.core.Lng;
import net.damaq.core.actions.CoreAction;
import net.damaq.gui.LaF;
import net.damaq.gui.LookAndFeels;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

final class ChangeLookAndFeelAction
extends CoreAction {
    private static final String CODE = "ChangeLookAndFeelAction";
    private final LaF laf;
    private static final Logger logger = Logger.getLogger(ChangeLookAndFeelAction.class.getName());

    public ChangeLookAndFeelAction(LaF laF) {
        super(CODE, laF.getName(), 0, null);
        this.laf = laF;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        try {
            bl = LookAndFeels.getInstance().loadLookAndFeel(this.laf, true);
            LookAndFeels.getInstance().storeSelectedLaF(this.laf);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            bl = false;
        }
        if (bl) {
            Swinger.showInformationDialog(ChangeLookAndFeelAction.getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.set"));
        } else {
            Swinger.showErrorDialog(ChangeLookAndFeelAction.getMainFrame(), Lng.getLabel("ChangeLookAndFeelAction.failed"));
        }
    }
}

