/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import javax.swing.JFrame;
import net.damaq.core.Lng;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.CheckVersion;
import net.damaq.core.actions.EventType;
import net.damaq.dialogs.ConnectDialog;
import net.damaq.utilities.BrowserControl;
import net.damaq.utilities.Swinger;

public final class CheckForNewVersion
extends BoardAction {
    private static final CheckForNewVersion INSTANCE = new CheckForNewVersion();
    private static final String CODE = "CheckForNewVersion";

    public static CheckForNewVersion getInstance() {
        return INSTANCE;
    }

    private CheckForNewVersion() {
        super(EventType.MISC, CODE, null, null);
    }

    public static void check(boolean bl) {
        JFrame jFrame = CheckForNewVersion.getMainFrame();
        CheckVersion checkVersion = new CheckVersion(bl);
        checkVersion.init();
        switch ((Integer)checkVersion.get()) {
            case 0: {
                int n = Swinger.getChoice(jFrame, Lng.getLabel("message.connect.newVersion"));
                if (n != 0) break;
                BrowserControl.showHomepage();
                break;
            }
            case 16: {
                if (!bl) break;
                Swinger.showErrorDialog(jFrame, Lng.getLabel("message.connect.exception", checkVersion.getErrorMessage()));
                break;
            }
            case 128: {
                if (!bl) break;
                Swinger.showErrorDialog(jFrame, Lng.getLabel("message.connect.noInetAvailable"));
                break;
            }
            default: {
                if (!bl) break;
                Swinger.showInformationDialog(jFrame, Lng.getLabel("message.connect.sameVersion"));
            }
        }
    }

    public void doAction() {
        super.doAction();
        JFrame jFrame = CheckForNewVersion.getMainFrame();
        int n = new ConnectDialog(jFrame).getModalResult();
        if (n == 0) {
            CheckForNewVersion.check(true);
        }
    }
}

