/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import net.damaq.core.AppPrefs;
import net.damaq.core.actions.RiderSwingWorker;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Utils;

final class CheckVersion
extends RiderSwingWorker {
    private static final Logger logger = Logger.getLogger(CheckVersion.class.getName());
    public static final int CONNECT_NEW_VERSION = 0;
    public static final int CONNECT_SAME_VERSION = 8;
    public static final int CONNECT_ERROR_EXCEPTION = 16;
    public static final int CONNECT_ERROR_INETCONNECTION_NOTAVAILABLE = 128;
    private static final String PARAM_VERSION = "version";

    public CheckVersion(boolean bl) {
        super(bl);
        if (bl) {
            this.dialogToClose.getProgressBar().setIndeterminate(true);
        }
    }

    public void finished() {
        super.finished();
        logger.info("--Checking version end--");
    }

    public final Object construct() {
        logger.info("--Checking version start--");
        if (AppPrefs.getProperty("proxy", false)) {
            System.setProperty("proxySet", "true");
            System.setProperty("https.proxyHost", AppPrefs.getProperty("proxy.url", "localhost"));
            System.setProperty("https.proxyPort", AppPrefs.getProperty("proxy.port", "8080"));
            System.setProperty("proxyHost", AppPrefs.getProperty("proxy.url", "localhost"));
            System.setProperty("proxyPort", AppPrefs.getProperty("proxy.port", "8080"));
            if (AppPrefs.getProperty("proxy.login", false)) {
                Authenticator.setDefault(new HttpAuthenticateProxy(AppPrefs.getProperty("proxy.username", ""), Utils.generateXorString(AppPrefs.getProperty("proxy.password", ""))));
            }
        } else {
            System.setProperty("proxySet", "false");
        }
        return this.checkIt();
    }

    private int checkIt() {
        HttpURLConnection httpURLConnection = null;
        this.showInfoWhileLoading("message.connect.status.connecting");
        try {
            httpURLConnection = (HttpURLConnection)new URL("http://wordrider.net/checkdamaq.php").openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            logger.info("Connected to WordRider.net, Writing params");
            dataOutputStream.write(Utils.addParam("", PARAM_VERSION, "Damaq 1.01").getBytes());
            dataOutputStream.close();
            logger.info("reading Response");
            this.showInfoWhileLoading("message.connect.status.checking");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            logger.info("disconnecting");
            this.showInfoWhileLoading("message.connect.status.disconnect");
            httpURLConnection.disconnect();
            if (string != null && string.toLowerCase().equals("yes")) {
                return 0;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return 128;
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            LogUtils.processException(logger, iOException);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return 16;
        }
        return 8;
    }

    private static final class HttpAuthenticateProxy
    extends Authenticator {
        private final String proxyUsername;
        private final String proxyPassword;

        public HttpAuthenticateProxy(String string, String string2) {
            this.proxyUsername = string;
            this.proxyPassword = string2;
        }

        protected final PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxyUsername, this.proxyPassword.toCharArray());
        }
    }
}

