/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import javax.swing.KeyStroke;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.ManagerDirector;

public final class EditorModeAction
extends BoardAction {
    private static final EditorModeAction instance = new EditorModeAction();

    private EditorModeAction() {
        super(EventType.EDITOR, "EditorModeAction", KeyStroke.getKeyStroke("F4"), "setup.gif");
        this.setUnique(false);
    }

    public static EditorModeAction getInstance() {
        return instance;
    }

    public final void doAction() {
        Game game = EditorModeAction.getGame();
        boolean bl = !game.isEditorMode();
        game.setEditorMode(bl);
        DrawBoard drawBoard = EditorModeAction.getDrawBoard();
        if (drawBoard == null) {
            return;
        }
        drawBoard.setEditorMode(bl);
        this.setSelected(bl);
        if (bl) {
            ManagerDirector.getInstance().getDesktopManager().addEditor();
        } else {
            ManagerDirector.getInstance().getDesktopManager().removeEditor();
            game.resetGameStatus();
        }
    }
}

