/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.MainAppFrame;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.actions.SaveAsFileAction;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class ExitAction
extends BoardAction {
    private static final ExitAction INSTANCE = new ExitAction();
    private static final String CODE = "ExitAction";
    private static final Logger logger = Logger.getLogger(ExitAction.class.getName());

    private ExitAction() {
        super(EventType.EXIT, CODE, KeyStroke.getKeyStroke(115, 8), "exit.gif");
    }

    public static ExitAction getInstance() {
        return INSTANCE;
    }

    private static void storeWindowPosition() {
        if (AppPrefs.getProperty("position", true)) {
            JFrame jFrame = ExitAction.getMainFrame();
            AppPrefs.storeProperty("posMax", jFrame.getExtendedState() == 6);
            AppPrefs.storeProperty("posH", jFrame.getHeight());
            AppPrefs.storeProperty("posW", jFrame.getWidth());
            AppPrefs.storeProperty("posX", jFrame.getX());
            AppPrefs.storeProperty("posY", jFrame.getY());
        } else {
            AppPrefs.removeProperty("posH");
            AppPrefs.removeProperty("posW");
            AppPrefs.removeProperty("posX");
            AppPrefs.removeProperty("posMax");
            AppPrefs.removeProperty("posY");
        }
        ManagerDirector.getInstance().getDesktopManager().closeAll();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        MainAppFrame mainAppFrame = MainApp.getInstance().getMainAppFrame();
        if (AppPrefs.getProperty("askWhenExit", true)) {
            int n = Swinger.getChoiceCancel(mainAppFrame, Lng.getLabel("message.confirm.exit"));
            if (n == 0) {
                SaveAsFileAction.getInstance().actionPerformed(null);
                this.offerToFront();
            } else if (n == 1) {
                this.doAction();
            }
        } else {
            this.doAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() {
        super.doAction();
        try {
            ManagerDirector.getInstance().getRecentFilesManager().storeRecentFiles();
            ExitAction.storeWindowPosition();
            AppPrefs.store();
            System.out.println("Exiting. Thanks for using Damaq!");
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        finally {
            System.exit(0);
        }
    }
}

