/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.player.Player;

abstract class GamePlayersAction
extends BoardAction {
    private static final Logger logger = Logger.getLogger(GamePlayersAction.class.getName());
    private final boolean firstPlayer;
    private final boolean secondPlayer;

    protected GamePlayersAction(String string, KeyStroke keyStroke, String string2, boolean bl, boolean bl2) {
        super(EventType.PLAYING_USER, string, keyStroke, string2);
        this.firstPlayer = bl;
        this.secondPlayer = bl2;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        logger.info("Game Players set");
        Game game = GamePlayersAction.getGame();
        Player player = game.getActivePlayer();
        Player player2 = game.getOppositePlayer();
        boolean bl = player.isHuman();
        boolean bl2 = player2.isHuman();
        GameCombination gameCombination = bl && bl2 ? GameCombination.PLAYER_PLAYER : (!bl && !bl2 ? GameCombination.COMP_COMP : GameCombination.PLAYER_COMP);
        if (gameCombination != GameCombination.PLAYER_COMP || !(this.firstPlayer ^ this.secondPlayer)) {
            if (bl2 != this.secondPlayer) {
                game.setOppositePlayer(this.secondPlayer);
            }
            if (bl != this.firstPlayer) {
                this.offerToFront();
            }
        }
    }

    public final void doAction() {
        super.doAction();
        Game game = GamePlayersAction.getGame();
        game.setActivePlayer(this.firstPlayer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum GameCombination {
        PLAYER_PLAYER,
        PLAYER_COMP,
        COMP_COMP;

    }
}

