/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.damaq.core.actions.CoreAction;
import net.damaq.utilities.ClipboardUtils;

abstract class ImageClipboardExporter
extends CoreAction {
    protected ImageClipboardExporter(String string, KeyStroke keyStroke, String string2) {
        super(string, keyStroke, string2);
    }

    protected abstract Image getImage();

    static BufferedImage createImage(JComponent jComponent) {
        boolean bl = jComponent.isOpaque();
        jComponent.setOpaque(true);
        Dimension dimension = jComponent.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        jComponent.setOpaque(bl);
        return bufferedImage;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        ClipboardUtils.setClipboard(image);
    }
}

