/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.actions.RiderSwingWorker;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNSynAn;
import net.damaq.pdn.exceptions.AnalyseException;
import net.damaq.pdn.exceptions.InvalidStructureFormatException;
import net.damaq.pdn.exceptions.LexException;
import net.damaq.pdn.exceptions.SyntException;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;
import net.damaq.utilities.Utils;

public final class LoadFileAction
extends RiderSwingWorker {
    private static final Logger logger = Logger.getLogger(LoadFileAction.class.getName());
    private final File file;

    public LoadFileAction(File file) {
        super(true);
        this.file = file;
    }

    public final Object construct() {
        JProgressBar jProgressBar = this.dialogToClose.getProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setStringPainted(true);
        this.showInfoWhileLoading("message.loading");
        List<PDNGame> list = null;
        String string = AppPrefs.getProperty("pdnCharset", Charset.defaultCharset().name());
        try {
            PDNSynAn pDNSynAn = new PDNSynAn();
            pDNSynAn.init(Utils.loadFile(this.file, string));
            pDNSynAn.parse();
            list = pDNSynAn.getPdnGames();
        }
        catch (InvalidStructureFormatException invalidStructureFormatException) {
            LogUtils.processException(logger, invalidStructureFormatException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.InvalidStructureFormatException", invalidStructureFormatException.getLine()));
        }
        catch (LexException lexException) {
            LogUtils.processException(logger, lexException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.LexException", lexException.getLine(), lexException.getFound(), lexException.getExpected()));
        }
        catch (SyntException syntException) {
            LogUtils.processException(logger, syntException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.SyntException", syntException.getLine()));
        }
        catch (AnalyseException analyseException) {
            LogUtils.processException(logger, analyseException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.AnalyseException", analyseException.getLine()));
        }
        catch (IllegalFormatException illegalFormatException) {
            LogUtils.processException(logger, illegalFormatException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.IllegalFormatException", illegalFormatException.getMessage()));
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.loadAndFormatLabel("message.error.reading", iOException.getMessage()));
        }
        return list;
    }
}

