/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import javax.swing.KeyStroke;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.HistoryItem;
import net.damaq.core.managers.HistoryManager;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.utilities.Swinger;

public final class MoveBackAction
extends BoardAction {
    private static final MoveBackAction instance = new MoveBackAction();

    private MoveBackAction() {
        super(EventType.TAKE_BACK, "MoveBackAction", KeyStroke.getKeyStroke(8, 0), "undo.gif");
        this.setUnique(false);
    }

    public final void doAction() {
        super.doAction();
        Game game = MoveBackAction.getGame();
        HistoryManager historyManager = game.getHistoryManager();
        if (historyManager.canUndo()) {
            HistoryItem historyItem = historyManager.doUndo();
            Board board = historyItem.getBoard();
            if (historyItem.isMoveBack() && historyItem.isJumps()) {
                MoveBackAction.getDrawBoard().undoMove(historyItem.getMove(), historyItem.getJumpedPieces(), board);
            } else {
                BoardManager boardManager = game.getManager().getBoardManager();
                boardManager.setBoard(board);
            }
            game.updateActivePlayer();
            if (!game.getActivePlayer().isHuman()) {
                Swinger.sleep(600);
            }
        }
    }

    public static MoveBackAction getInstance() {
        return instance;
    }
}

