/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import javax.swing.KeyStroke;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.HistoryItem;
import net.damaq.core.managers.HistoryManager;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.utilities.Swinger;

public final class MoveForwardAction
extends BoardAction {
    private static final MoveForwardAction instance = new MoveForwardAction();

    private MoveForwardAction() {
        super(EventType.FORWARD, "MoveForwardAction", KeyStroke.getKeyStroke(8, 2), "redo.gif");
        this.setUnique(false);
    }

    public final void doAction() {
        super.doAction();
        Game game = MoveForwardAction.getGame();
        HistoryManager historyManager = game.getHistoryManager();
        if (historyManager.canRedo()) {
            HistoryItem historyItem = historyManager.getActiveItem();
            HistoryItem historyItem2 = historyManager.doRedo();
            if (historyItem.isMove()) {
                MoveForwardAction.getDrawBoard().doMove(historyItem.getMove(), true);
            } else {
                Board board = historyItem2.getBoard();
                BoardManager boardManager = game.getManager().getBoardManager();
                boardManager.setBoard(board);
            }
            game.updateActivePlayer();
            if (!game.getActivePlayer().isHuman()) {
                Swinger.sleep(600);
            }
        }
    }

    public static MoveForwardAction getInstance() {
        return instance;
    }
}

