/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.utilities.Swinger;

public final class NewGameAction
extends BoardAction {
    private static final NewGameAction instance = new NewGameAction();

    private NewGameAction() {
        super(EventType.NEW_GAME, "CreateNewGameAction", KeyStroke.getKeyStroke(78, 2), "new.gif");
    }

    public static NewGameAction getInstance() {
        return instance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            int n;
            if (AppPrefs.getProperty("askWhenNew", true) && (n = Swinger.getChoice(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("message.confirm.startNewGame"))) == 1) {
                return;
            }
            Swinger.playSound(Swinger.getCachedAudioClip("newgame.wav"));
        }
        super.actionPerformed(actionEvent);
    }

    public final void doAction() {
        super.doAction();
        ManagerDirector managerDirector = ManagerDirector.getInstance();
        BoardManager boardManager = managerDirector.getGameStyleManager().getBoardManager();
        Game game = NewGameAction.getGame();
        boardManager.setBoard(game.getManager().getCurrentGameStyle().newStartBoard());
        game.init();
    }
}

