/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.actions.LoadFileAction;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.dialogs.AppDialog;
import net.damaq.dialogs.GameDetails;
import net.damaq.dialogs.RiderFileFilter;
import net.damaq.dialogs.pdn.PDNGamesDialog;
import net.damaq.pdn.PDNGame;
import net.damaq.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenFileAction
extends BoardAction {
    private static final OpenFileAction instance = new OpenFileAction();

    public static OpenFileAction getInstance() {
        return instance;
    }

    private OpenFileAction() {
        super(EventType.OPEN, "OpenFileAction", KeyStroke.getKeyStroke(79, 2), "open.gif");
        this.setUnique(true);
    }

    private static void updateFileFilters(JFileChooser jFileChooser, List<RiderFileFilter> list) {
        for (RiderFileFilter riderFileFilter : list) {
            jFileChooser.addChoosableFileFilter(riderFileFilter);
        }
        int n = AppPrefs.getProperty("openfilter", list.size() - 1);
        if (n >= 0 && n < list.size()) {
            jFileChooser.setFileFilter(list.get(n));
        }
    }

    private static File getOpenFileDialog(List<RiderFileFilter> list) {
        File file = new File(AppPrefs.getProperty("lastOpenFolder", ""));
        JFileChooser jFileChooser = new JFileChooser(file);
        OpenFileAction.updateFileFilters(jFileChooser, list);
        jFileChooser.setDialogTitle(Lng.getLabel("OpenFileAction.dialog.title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(OpenFileAction.getMainFrame());
        if (n != 0) {
            return null;
        }
        AppPrefs.storeProperty("openfilter", list.indexOf(jFileChooser.getFileFilter()));
        return jFileChooser.getSelectedFile();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!OpenFileAction.getGame().getActivePlayer().isHuman()) {
            this.offerToFront();
        } else {
            this.doAction();
        }
    }

    public static boolean open(File file) {
        Object object;
        if (file == null) {
            return false;
        }
        if (!file.isFile() || !file.exists()) {
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), Lng.getLabel("message.error.FNF", file.getAbsolutePath()));
            return false;
        }
        AppPrefs.storeProperty("lastOpenFolder", file.getAbsolutePath());
        LoadFileAction loadFileAction = new LoadFileAction(file);
        loadFileAction.init();
        List list = (List)loadFileAction.get();
        if (list == null) {
            return false;
        }
        GameDetails gameDetails = null;
        if (list.size() == 1 && AppPrefs.getProperty("openSimplePDNFast", true)) {
            gameDetails = new GameDetails((PDNGame)list.get(0));
            gameDetails.updateData();
            if (!gameDetails.isValidHistory()) {
                gameDetails = null;
            }
        }
        if (gameDetails == null) {
            object = new PDNGamesDialog((Frame)MainApp.getInstance().getMainAppFrame(), file, list);
            if (((AppDialog)object).getModalResult() != 0) {
                return true;
            }
            gameDetails = ((PDNGamesDialog)object).getSelectedGameDetails();
        }
        object = OpenFileAction.getGame();
        ((Game)object).loadGame(gameDetails);
        ManagerDirector.getInstance().getRecentFilesManager().fileWasOpened(file);
        return true;
    }

    private static List<RiderFileFilter> getFileFilters() {
        ArrayList<RiderFileFilter> arrayList = new ArrayList<RiderFileFilter>(3);
        arrayList.add(new RiderFileFilter(new String[]{"pdn"}, "OpenFileAction.dialog.filterPDN"));
        return arrayList;
    }

    @Override
    public void doAction() {
        File file = OpenFileAction.getOpenFileDialog(OpenFileAction.getFileFilters());
        if (file != null) {
            OpenFileAction.open(file);
        }
    }
}

