/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EditorModeAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.Game;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.pdn.PDNFENDescription;
import net.damaq.utilities.ClipboardUtils;
import net.damaq.utilities.Swinger;

public class PasteFENAction
extends BoardAction {
    private static final PasteFENAction instance = new PasteFENAction();

    private PasteFENAction() {
        super(EventType.PASTE_FEN, "PasteFENAction", KeyStroke.getKeyStroke(86, 2), null);
        this.setUnique(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.canPaste()) {
            return;
        }
        if (!PasteFENAction.getGame().isEditorMode()) {
            EditorModeAction.getInstance().actionPerformed(actionEvent);
            this.offerToFront();
        } else {
            this.paste();
        }
    }

    private boolean canPaste() {
        String string = ClipboardUtils.getClipboard();
        return string != null && (string.startsWith("W:") || string.startsWith("B:"));
    }

    private void paste() {
        String string;
        Game game = PasteFENAction.getGame();
        if (game.isEditorMode() && (string = ClipboardUtils.getClipboard()) != null) {
            Board board;
            try {
                PDNFENDescription pDNFENDescription = new PDNFENDescription(string);
                board = game.getManager().getCurrentGameStyle().newBoardInstance(pDNFENDescription);
            }
            catch (Exception exception) {
                Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("message.error.invalidFEN"));
                return;
            }
            if (board != null) {
                game.getManager().getBoardManager().setBoard(board);
                game.updateActivePlayer();
            }
        }
    }

    public boolean isEnabled() {
        return this.canPaste();
    }

    public void doAction() {
        super.doAction();
        this.paste();
    }

    public static PasteFENAction getInstance() {
        return instance;
    }

    public void updateEnable() {
        this.setEnabled(this.isEnabled());
    }
}

