/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.player.Player;

public final class PlayerToMoveAction
extends BoardAction {
    private static final PlayerToMoveAction instance = new PlayerToMoveAction();

    private PlayerToMoveAction() {
        super(EventType.X_ON_MOVE, "PlayerToMoveAction", KeyStroke.getKeyStroke("F3"), "pltomove_small.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Game game = PlayerToMoveAction.getGame();
        Player player = game.getActivePlayer();
        if (!player.isHuman()) {
            this.offerToFront();
        }
    }

    public final void doAction() {
        super.doAction();
        Game game = PlayerToMoveAction.getGame();
        game.setActivePlayer(true);
        if (game.getOppositePlayer().isHuman()) {
            game.setOppositePlayer(false);
        }
    }

    public static PlayerToMoveAction getInstance() {
        return instance;
    }
}

