/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.actions.interfaces.IFileType;
import net.damaq.core.managers.HistoryItem;
import net.damaq.dialogs.RiderFileFilter;
import net.damaq.dialogs.pdn.PDNPropertiesDialog;
import net.damaq.export.AppletExporter;
import net.damaq.export.Exporter;
import net.damaq.export.PDNExporter;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.pdn.PDNGame;
import net.damaq.utilities.Consts;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;
import net.damaq.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SaveAsFileAction
extends BoardAction {
    private static final Logger logger = Logger.getLogger(SaveAsFileAction.class.getName());
    private static final SaveAsFileAction instance = new SaveAsFileAction();
    private static final String CODE = "SaveAsFileAction";
    private static final String LASTFOLDER_KEY = "lastOpenFolder";

    public static SaveAsFileAction getInstance() {
        return instance;
    }

    private SaveAsFileAction() {
        super(EventType.SAVE, CODE, KeyStroke.getKeyStroke(83, 2), "save.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveDataToFile(Frame frame, File file, byte[] byArray, boolean bl) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
            if (bl) {
                byte[] byArray2 = Consts.LINE_SEPARATOR.getBytes();
                fileOutputStream.write(byArray2);
                fileOutputStream.write(byArray2);
            }
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
            Swinger.showErrorDialog(frame, Lng.getLabel("message.error.saving", iOException.getMessage()));
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
        return true;
    }

    private static boolean runSaveProcess(JFrame jFrame, File file, boolean bl, byte[] byArray, boolean bl2) {
        logger.info(new String(byArray));
        boolean bl3 = bl && file.exists() && file.length() > 0L;
        boolean bl4 = SaveAsFileAction.saveDataToFile(jFrame, file, byArray, bl3);
        if (bl4 && jFrame != null && bl2 && AppPrefs.getProperty("infoSuccesful", true)) {
            Swinger.showInformationDialog(jFrame, Lng.getLabel("message.information.savedSuccess", file.getAbsolutePath()));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static File uniSaveProcess(Frame frame, List<RiderFileFilter> list, RiderFileFilter riderFileFilter, String string) {
        int n;
        void var9_12;
        File file = new File(AppPrefs.getProperty(LASTFOLDER_KEY, ""));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle(Lng.getLabel("SaveAsFileAction.dialog.title"));
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        String string2 = Utils.getExtension(string);
        if ((string2 == null || riderFileFilter.getExtension().equalsIgnoreCase(string2)) && fileChooserUI instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)fileChooserUI).setFileName(string);
        }
        for (RiderFileFilter object2 : list) {
            jFileChooser.addChoosableFileFilter(object2);
        }
        jFileChooser.setFileFilter(riderFileFilter);
        if (jFileChooser.showSaveDialog(frame) != 0) {
            return null;
        }
        FileFilter fileFilter = jFileChooser.getFileFilter();
        AppPrefs.storeProperty("savefilter", list.indexOf(jFileChooser.getFileFilter()));
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            return null;
        }
        IFileType iFileType = (IFileType)((Object)fileFilter);
        if (Utils.getExtension(file2) == null) {
            String string3 = iFileType.getExtension();
            File file3 = new File(file2.getPath().concat(".").concat(string3));
        }
        if (iFileType.askForRewrite() && var9_12.exists() && (n = Swinger.getChoice(frame, Lng.getLabel("message.confirm.overwrite"))) == 1) {
            return null;
        }
        AppPrefs.storeProperty(LASTFOLDER_KEY, var9_12.getAbsolutePath());
        AppPrefs.storeProperty("lastFileName", var9_12.getName());
        return var9_12;
    }

    private static boolean saveAsProcess(boolean bl) {
        Exporter exporter;
        File file;
        JFrame jFrame = SaveAsFileAction.getMainFrame();
        PDNGame pDNGame = SaveAsFileAction.getGame().getGameInfoManager().getPdnGame();
        if (instance == null) {
            return false;
        }
        List<RiderFileFilter> list = SaveAsFileAction.getFileFilters();
        int n = list.size();
        int n2 = AppPrefs.getProperty("savefilter", 0);
        if (n2 < 0 || n2 >= n - 1) {
            n2 = 0;
        }
        if ((file = SaveAsFileAction.uniSaveProcess(jFrame, list, list.get(n2), AppPrefs.getProperty("lastFileName", ""))) == null) {
            return false;
        }
        int n3 = AppPrefs.getProperty("savefilter", 0);
        RiderFileFilter riderFileFilter = list.get(n3);
        if (riderFileFilter.getExtension().equals("pdn")) {
            PDNPropertiesDialog pDNPropertiesDialog = new PDNPropertiesDialog((Frame)jFrame, pDNGame, file);
            if (pDNPropertiesDialog.getModalResult() != 0) {
                return false;
            }
            SaveAsFileAction.getGame().getHistoryManager().setModified(false);
            exporter = new PDNExporter(SaveAsFileAction.getGame(), pDNGame);
        } else {
            List<HistoryItem> list2 = SaveAsFileAction.getGame().getHistoryManager().getMoveList();
            if (list2.size() <= 1) {
                Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.noMoves"));
                return false;
            }
            exporter = new AppletExporter(SaveAsFileAction.getGame());
        }
        exporter.init();
        return SaveAsFileAction.runSaveProcess(jFrame, file, !riderFileFilter.askForRewrite(), exporter.processData(), bl);
    }

    private static List<RiderFileFilter> getFileFilters() {
        ArrayList<RiderFileFilter> arrayList = new ArrayList<RiderFileFilter>(2);
        arrayList.add(new RiderFileFilter(new String[]{"pdn"}, "OpenFileAction.dialog.filterPDN"));
        GameStyle gameStyle = SaveAsFileAction.getGame().getManager().getCurrentGameStyle();
        if (gameStyle.getPDNCode() == 20) {
            arrayList.add(new RiderFileFilter(new String[]{"html", "htm"}, "SaveFileAction.dialog.filterApplet", true));
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!SaveAsFileAction.getGame().getActivePlayer().isHuman()) {
            this.offerToFront();
        } else {
            this.doAction();
        }
    }

    @Override
    public void doAction() {
        SaveAsFileAction.saveAsProcess(true);
    }
}

