/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.board;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.boardtools.BoardTool;
import net.damaq.core.boardtools.board.DrawBorder;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.managers.interfaces.BoardListener;
import net.damaq.core.managers.interfaces.MoveListener;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.gui.LookAndFeels;
import net.damaq.gui.SelSquareType;
import net.damaq.gui.Skin;
import net.damaq.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrawBoard
extends JComponent
implements BoardTool,
BoardListener,
ChangeListener {
    public static final String CODE = DrawBoard.class.getSimpleName();
    private final List<Integer> move = new ArrayList<Integer>();
    private final Set<Integer> nextJumps = new HashSet<Integer>();
    private final Set<Integer> nextEnd = new HashSet<Integer>();
    private Skin skin;
    private int sqWidth = 0;
    private boolean showReversed = false;
    private boolean showNumbers = true;
    private boolean showHints = true;
    private final Map<Integer, SelSquareType> selectedSquares = new HashMap<Integer, SelSquareType>();
    private int boardWidth = 0;
    private int boardMaxLength = 0;
    private JInternalFrame frame;
    private final BoardManager boardManager;
    private Rectangle contentRect;
    private FontMetrics fm = this.getFontMetrics(new Font("Dialog", 1, 13));
    private VolatileImage buffer = null;
    private final Vector<MoveListener> moveListeners = new Vector(2);
    private boolean requestMove = false;
    private boolean contentsLost = false;
    private double zoom = 1.0;
    private Insets insets;
    private boolean rebuildBuffer;
    private Cursor stopCursor;
    private Cursor stopWhiteCursor;
    private Cursor stopBlackCursor;
    private int zoomSqWidth;
    private Piece editorPiece = Piece.WHITE_PIECE;
    private boolean editorMode = false;

    public DrawBoard(BoardManager boardManager) {
        this.boardManager = boardManager;
        this.firstInit(boardManager);
        this.initSkin(LookAndFeels.getInstance().getActiveSkin());
        this.showReversed = AppPrefs.getProperty("board.reversedView", false);
        this.showNumbers = AppPrefs.getProperty("board.numbers", false);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        LookAndFeels.getInstance().addChangeListener(this);
    }

    private void firstInit(BoardManager boardManager) {
        Swinger.getCachedAudioClip("select.wav");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.stopCursor = toolkit.createCustomCursor(Swinger.getIconImage("cursor_stop.gif"), new Point(0, 0), "stop");
        this.stopWhiteCursor = toolkit.createCustomCursor(Swinger.getIconImage("stop_white.gif"), new Point(0, 0), "stop_white");
        this.stopBlackCursor = toolkit.createCustomCursor(Swinger.getIconImage("stop_black.gif"), new Point(0, 0), "stop_black");
        this.boardWidth = boardManager.getBoardWidth();
        this.boardMaxLength = boardManager.getMaxBoardLength();
        this.setBorder(new DrawBorder());
    }

    private void initSkin(Skin skin) {
        this.sqWidth = skin.getBlackBar().getWidth(null);
        this.setZoomWithSkin(skin, AppPrefs.getProperty("board.zoomView", 100));
        this.skin = skin;
    }

    private void setZoomWithSkin(Skin skin, int n) {
        this.zoom = (double)n / 100.0;
        this.insets = new Insets((int)((double)skin.getFrameTop().getHeight(null) * this.zoom), (int)((double)skin.getFrameLeft().getWidth(null) * this.zoom), (int)((double)skin.getFrameBottom().getHeight(null) * this.zoom), (int)((double)skin.getFrameRight().getWidth(null) * this.zoom));
        this.zoomSqWidth = (int)((double)this.sqWidth * this.zoom);
        int n2 = this.zoomSqWidth * this.boardWidth;
        int n3 = this.insets.left + this.insets.right + n2;
        int n4 = this.insets.top + this.insets.bottom + n2;
        this.contentRect = new Rectangle(this.insets.left, this.insets.top, n2, n2);
        Dimension dimension = new Dimension(n3, n4);
        this.setPreferredSize(dimension);
        skin.setSqWidth(this.zoomSqWidth);
        if (this.frame != null) {
            this.rebuildBuffer = true;
            this.frame.setSize(dimension);
        }
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public final void boardContentChanged(List<Integer> list) {
        this.setSelected();
    }

    @Override
    public final void boardChanged() {
    }

    private void setSelected() {
        this.repaintContent();
    }

    private void deselectSquares() {
        this.nextJumps.clear();
        this.nextEnd.clear();
        this.selectedSquares.clear();
        this.setSelected();
    }

    @Override
    public final String getTitle() {
        return "";
    }

    public final void setBoardNumbers(boolean bl) {
        this.showNumbers = bl;
        this.repaintContent();
    }

    public final void setReversedView(boolean bl) {
        this.showReversed = bl;
        this.repaintContent();
    }

    public final void setZoom(int n) {
        this.setZoomWithSkin(this.skin, n);
    }

    public final void setEditorPiece(Piece piece) {
        this.editorPiece = piece;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.initSkin(((LookAndFeels)changeEvent.getSource()).getActiveSkin());
        this.repaintContent();
        this.frame.revalidate();
        this.frame.repaint();
    }

    public final void setRequestMove(boolean bl) {
        assert (bl != this.requestMove);
        if (this.requestMove && !bl) {
            this.deselectSquares();
        }
        this.move.clear();
        this.requestMove = bl;
    }

    public final void selectPosition(int n) {
        if (this.requestMove && this.canMoveWithLeft(n) && (this.move.isEmpty() || this.move.get(0) != n)) {
            this.doActionLeft(n);
        }
    }

    private void mouseClickedLeft(int n) {
        if (this.requestMove && this.canMoveWithLeft(n)) {
            this.doActionLeft(n);
        } else if (this.editorMode) {
            Piece piece = this.boardManager.get(n);
            if (piece == this.editorPiece) {
                return;
            }
            if (piece == Piece.NOTHING || Side.getSide(piece) != Side.getSide(this.editorPiece)) {
                int[] nArray = this.boardManager.getCounts();
                int n2 = ManagerDirector.getInstance().getGame().getManager().getCurrentGameStyle().maxPiecesForSide();
                if (Piece.isWhite(this.editorPiece)) {
                    if (nArray[0] == n2) {
                        DrawBoard.showError(Lng.loadAndFormatLabel("message.error.whiteMaximum", n2));
                        return;
                    }
                } else if (nArray[1] == n2) {
                    DrawBoard.showError(Lng.loadAndFormatLabel("message.error.blackMaximum", n2));
                    return;
                }
            }
            this.boardManager.setWithUpgrade(n, this.editorPiece);
        }
    }

    private void doActionLeft(int n) {
        boolean bl;
        boolean bl2 = bl = this.move.size() > 3 && this.move.get(0) == n;
        if (this.boardManager.isOurs(n) && !bl) {
            this.selectedSquares.clear();
            if (this.move.size() != 1 || this.move.get(0) != n) {
                this.move.clear();
                this.selectedSquares.put(n, SelSquareType.START_MOVE);
                Swinger.playSound("select.wav");
                this.move.add(n);
            } else {
                this.move.clear();
            }
            this.updateSuggestedMove();
            this.setSelected();
            this.moveSelectStart();
        }
        if (this.nextEnd.contains(n)) {
            this.selectedSquares.put(n, SelSquareType.END_MOVE);
            this.move.add(n);
            this.nextJumps.clear();
            this.nextEnd.clear();
            this.requestMove = false;
            this.setSelected();
            this.moveFinish();
        } else if (!this.move.isEmpty() && (this.boardManager.isEmpty(n) || this.nextJumps.contains(n))) {
            int n2 = this.move.size() - 1;
            boolean bl3 = false;
            if (this.move.get(n2) == n) {
                this.selectedSquares.remove(n);
                this.move.remove(n2);
                bl3 = true;
            } else if (this.nextJumps.contains(n)) {
                this.selectedSquares.put(n, SelSquareType.MIDDLE_MOVE);
                this.move.add(n);
                bl3 = true;
            }
            if (bl3) {
                this.updateSuggestedMove();
                this.setSelected();
                this.moveSelect();
            }
        }
    }

    private void mouseClickedRight(int n) {
        if (this.editorMode) {
            this.boardManager.set(n, Piece.NOTHING);
        }
    }

    private void renderOffscreen(boolean bl) {
        do {
            if (bl || this.buffer == null || this.buffer.validate(this.getGraphicsConfiguration()) == 2) {
                this.buffer = this.createVolatileImage(this.contentRect.width, this.contentRect.width);
            }
            Graphics2D graphics2D = this.buffer.createGraphics();
            this.paintBoard(graphics2D);
            graphics2D.dispose();
        } while (this.buffer.contentsLost());
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        do {
            if (this.buffer == null || this.rebuildBuffer) {
                this.renderOffscreen(true);
                this.rebuildBuffer = false;
            } else if (this.buffer.contentsLost() || this.contentsLost) {
                this.renderOffscreen(false);
                this.contentsLost = false;
            } else {
                int n = this.buffer.validate(this.getGraphicsConfiguration());
                if (n == 1) {
                    this.renderOffscreen(false);
                } else if (n == 2) {
                    this.renderOffscreen(true);
                }
            }
            graphics.drawImage(this.buffer, this.contentRect.x, this.contentRect.y, null);
        } while (this.buffer.contentsLost() || this.contentsLost);
    }

    private void paintBoard(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = 1;
        Skin skin = this.getSkin();
        for (int i = 0; i < this.boardWidth; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.boardWidth; ++j) {
                if ((j & 1) != (i & 1)) {
                    this.updateSquare(skin, n, graphics2D);
                    ++n;
                } else {
                    graphics.drawImage(skin.getWhiteBarZoomed(), 0, 0, null);
                }
                graphics.translate(this.zoomSqWidth, 0);
                n2 += this.zoomSqWidth;
            }
            graphics.translate(-n2, this.zoomSqWidth);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    private Skin getSkin() {
        return this.skin;
    }

    private void updateSquare(Skin skin, int n, Graphics2D graphics2D) {
        Object object;
        int n2 = this.showReversed ? this.boardMaxLength - n + 1 : n;
        Piece piece = this.boardManager.get(n2);
        graphics2D.drawImage(skin.getPieceImageZoomed(piece), 0, 0, this);
        graphics2D.scale(this.zoom, this.zoom);
        if (this.selectedSquares.containsKey(n2)) {
            graphics2D.setColor(skin.getRectColor(this.selectedSquares.get(n2)));
            object = graphics2D.getStroke();
            graphics2D.setStroke(skin.getSelStroke());
            int n3 = skin.getRectangleWidth();
            graphics2D.drawRect(n3 - 1, n3 - 1, this.sqWidth - n3 - 1, this.sqWidth - n3 - 1);
            graphics2D.setStroke((Stroke)object);
        }
        if (this.showHints) {
            if (this.nextEnd.contains(n2)) {
                graphics2D.setColor(skin.getRectColor(SelSquareType.END_MOVE));
                graphics2D.drawOval(this.sqWidth / 2 - 2, this.sqWidth / 2 - 2, 4, 4);
            } else if (this.nextJumps.contains(n2)) {
                graphics2D.setColor(skin.getRectColor(SelSquareType.MIDDLE_MOVE));
                graphics2D.drawOval(this.sqWidth / 2 - 2, this.sqWidth / 2 - 2, 4, 4);
            }
        }
        if (this.showNumbers) {
            object = graphics2D.getFont();
            graphics2D.setColor(skin.getSelectRectColor());
            graphics2D.setFont(this.fm.getFont());
            String string = Integer.toString(n2);
            graphics2D.drawString(string, this.sqWidth - 3 - this.fm.stringWidth(string), this.sqWidth - skin.getRectangleWidth() - 2);
            graphics2D.setFont((Font)object);
        }
        double d = 1.0 / this.zoom;
        graphics2D.scale(d, d);
    }

    @Override
    public final String getCode() {
        return CODE;
    }

    public final void addMoveListener(MoveListener moveListener) {
        this.moveListeners.add(moveListener);
    }

    public final void removeMoveListener(MoveListener moveListener) {
        this.moveListeners.remove(moveListener);
    }

    @Override
    public final void onToolInit(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
    }

    @Override
    public final void onToolStart() {
        this.boardManager.addBoardChangeListener(this);
    }

    @Override
    public final void onToolDestroy() {
        this.boardManager.removeBoardListener(this);
    }

    private void repaintContent() {
        if (this.buffer != null) {
            this.contentsLost = true;
            this.buffer.flush();
            this.repaint(this.contentRect);
        }
    }

    private boolean canMoveWithLeft(int n) {
        if (this.boardManager.isOurs(n)) {
            LinkedList<Move> linkedList = new LinkedList<Move>();
            boolean bl = this.boardManager.generateMoves(linkedList);
            for (Move move : linkedList) {
                if (move.getPosition(1) != n) continue;
                return true;
            }
            if (bl) {
                DrawBoard.showError(Lng.getLabel("message.error.jumps"));
            } else {
                this.showStopCursor(this.stopCursor);
            }
        } else if (!this.boardManager.isEmpty(n)) {
            if (this.boardManager.isSideToMove(Side.WHITES)) {
                this.showStopCursor(this.stopBlackCursor);
            } else {
                this.showStopCursor(this.stopWhiteCursor);
            }
        }
        return this.boardManager.isEmpty(n);
    }

    private void updateSuggestedMove() {
        this.nextJumps.clear();
        this.nextEnd.clear();
        if (this.move.isEmpty()) {
            return;
        }
        LinkedList<Move> linkedList = new LinkedList<Move>();
        this.boardManager.generateMoves(linkedList);
        int n = this.move.size();
        for (Move move : linkedList) {
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (move.getPosition(i + 1) == this.move.get(i).intValue()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            assert (move.size() >= n + 1);
            if (move.size() > n + 1) {
                this.nextJumps.add(move.getPosition(n + 1));
                continue;
            }
            this.nextEnd.add(move.getPosition(n + 1));
        }
    }

    @Override
    public void onToolClosing() {
    }

    public final void undoMove(Move move, List<Integer> list, Board board) {
        assert (move != null);
        this.boardManager.setMoving(true);
        this.boardManager.set(move.getLastPosition(), Piece.NOTHING);
        Swinger.sleep(150);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.boardManager.set(n, board.get(n));
            Swinger.sleep(200);
        }
        this.boardManager.set(move.getFirstPosition(), board.get(move.getFirstPosition()));
        this.boardManager.setSideToMove(board.isSideToMove(Side.WHITES) ? Side.WHITES : Side.BLACKS);
        this.boardManager.setMoving(false);
    }

    public final List<Integer> doMove(Move move, boolean bl) {
        Object object;
        assert (move != null);
        this.boardManager.setMoving(true);
        int n = move.size();
        int n2 = move.getPosition(1);
        if (bl) {
            this.selectedSquares.clear();
            this.nextEnd.clear();
            this.nextJumps.clear();
            for (int i = 2; i < n; ++i) {
                this.selectedSquares.put(move.getPosition(i), SelSquareType.MIDDLE_MOVE);
            }
            this.selectedSquares.put(n2, SelSquareType.START_MOVE);
            this.selectedSquares.put(move.getPosition(n), SelSquareType.END_MOVE);
            this.setSelected();
            Swinger.sleep(200);
        }
        HashMap<Integer, Piece> hashMap = new HashMap<Integer, Piece>(2);
        Piece piece = this.boardManager.get(n2);
        for (int i = 1; i < n; ++i) {
            int n3 = move.getPosition(i);
            object = this.boardManager.get(n3);
            hashMap.clear();
            hashMap.put(n3, Piece.NOTHING);
            this.selectedSquares.remove(n3);
            hashMap.put(move.getPosition(i + 1), (Piece)((Object)object));
            this.boardManager.set(hashMap);
            Swinger.playSound("push.wav");
            Swinger.sleep(300);
        }
        this.boardManager.getBoard().set(n2, piece);
        if (move.getPosition(n) != n2) {
            this.boardManager.getBoard().set(move.getPosition(n), Piece.NOTHING);
        }
        List<Integer> list = this.boardManager.doMove(move, false);
        Piece piece2 = this.boardManager.get(move.getPosition(n));
        if (Piece.isKing(piece2) && !Piece.isKing(piece)) {
            Swinger.playSound(Piece.isWhite(piece2) ? "bless_w.wav" : "bless_b.wav");
            Swinger.sleep(300);
        }
        object = list.iterator();
        while (object.hasNext()) {
            int n4 = (Integer)object.next();
            this.boardManager.set(n4, Piece.NOTHING);
            Swinger.playSound("remove.wav");
            Swinger.sleep(300);
        }
        this.selectedSquares.clear();
        this.setSelected();
        this.boardManager.setMoving(false);
        return list;
    }

    private void moveSelectStart() {
        MoveListener[] moveListenerArray;
        for (MoveListener moveListener : moveListenerArray = this.moveListeners.toArray(new MoveListener[this.moveListeners.size()])) {
            moveListener.onMoveStart(new LinkedList<Integer>(this.move));
        }
    }

    private void moveSelect() {
        MoveListener[] moveListenerArray;
        for (MoveListener moveListener : moveListenerArray = this.moveListeners.toArray(new MoveListener[this.moveListeners.size()])) {
            moveListener.onMoveSelect(new LinkedList<Integer>(this.move));
        }
    }

    private void moveFinish() {
        MoveListener[] moveListenerArray;
        Move move = ManagerDirector.getInstance().getGameStyleManager().generateGameMove(this.move);
        for (MoveListener moveListener : moveListenerArray = this.moveListeners.toArray(new MoveListener[this.moveListeners.size()])) {
            moveListener.onMoveFinish(move.doCopy());
        }
    }

    private void showStopCursor(final Cursor cursor) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DrawBoard.this.setCursor(cursor);
                Swinger.playSound("wrong.wav");
                Swinger.sleep(500);
                DrawBoard.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public final void setEditorMode(boolean bl) {
        this.editorMode = bl;
    }

    private static void showError(String string) {
        Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), string);
    }

    @Override
    public final Insets getInsets() {
        return this.insets;
    }

    @Override
    public final Icon getIcon() {
        return null;
    }

    public final boolean isRequestMove() {
        return this.requestMove;
    }

    @Override
    public void setToolbarVisible(boolean bl) {
    }

    final class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean windowDragging = false;
        private Point dragPoint;

        MouseHandler() {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            if (!DrawBoard.this.contentRect.contains(mouseEvent.getPoint())) {
                this.dragPoint = SwingUtilities.convertPoint(DrawBoard.this.frame, mouseEvent.getPoint(), DrawBoard.this.frame.getParent());
                this.windowDragging = true;
            }
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            if (this.windowDragging) {
                Point point = DrawBoard.this.frame.getLocation();
                Container container = DrawBoard.this.frame.getParent();
                Point point2 = SwingUtilities.convertPoint(DrawBoard.this.frame, mouseEvent.getPoint(), container);
                point.x += point2.x - this.dragPoint.x;
                point.y += point2.y - this.dragPoint.y;
                point.x = Math.max(0, Math.min(container.getWidth() - DrawBoard.this.frame.getWidth(), point.x));
                point.y = Math.max(0, Math.min(container.getHeight() - DrawBoard.this.frame.getHeight(), point.y));
                DrawBoard.this.frame.setLocation(point);
                this.dragPoint = point2;
            }
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            if (!this.windowDragging && DrawBoard.this.contentRect.contains(mouseEvent.getPoint())) {
                mouseEvent.translatePoint(-((DrawBoard)DrawBoard.this).contentRect.x, -((DrawBoard)DrawBoard.this).contentRect.y);
                int n = mouseEvent.getX() / DrawBoard.this.zoomSqWidth;
                int n2 = mouseEvent.getY() / DrawBoard.this.zoomSqWidth;
                if ((n & 1) != (n2 & 1)) {
                    int n3 = DrawBoard.this.boardManager.getPosition(n2, n);
                    if (DrawBoard.this.showReversed) {
                        n3 = DrawBoard.this.boardMaxLength - n3 + 1;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        DrawBoard.this.mouseClickedLeft(n3);
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        DrawBoard.this.mouseClickedRight(n3);
                    }
                }
            }
            this.windowDragging = false;
        }
    }
}

