/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.damexchange;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.damaq.core.Lng;
import net.damaq.core.actions.ShowChatWindowAction;
import net.damaq.core.boardtools.AbstractBoardTool;
import net.damaq.core.boardtools.damexchange.ConnectToAction;
import net.damaq.core.boardtools.damexchange.StartServerAction;
import net.damaq.core.boardtools.damexchange.TerminateConnectionAction;
import net.damaq.core.managers.Game;
import net.damaq.core.swing.DamaqUI;
import net.damaq.damexchange.ConnectionEvent;
import net.damaq.damexchange.ConnectionListener;
import net.damaq.damexchange.DamExchangeManager;
import net.damaq.damexchange.DamExchangeMsgEvent;
import net.damaq.damexchange.DamExchangeMsgListener;
import net.damaq.damexchange.ServerConnection;
import net.damaq.damexchange.messages.ChatMessage;
import net.damaq.dialogs.LimitedPlainDocument;
import net.damaq.gui.ToolbarSeparator;
import net.damaq.utilities.BrowserControl;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class ChatWindow
extends AbstractBoardTool
implements DamExchangeMsgListener,
ConnectionListener {
    public static final String CODE = ChatWindow.class.getSimpleName();
    private static final Logger logger = Logger.getLogger(ChatWindow.class.getName());
    private final StyleContext sc = new StyleContext();
    private final StyledDocument document = new DefaultStyledDocument(this.sc);
    private final JPanel panel = new JPanel(new BorderLayout());
    private JTextField inputField = new JTextField();
    private JToolBar toolbar;
    private final Rectangle scrollRect = new Rectangle(4, Integer.MAX_VALUE, 0, 0);
    private DamExchangeManager damExManager;
    private JTextPane pane = new JTextPane(this.document);
    private static Style normalStyle;
    private static Style messageStyleOut;
    private static Style messageStyleIn;
    private static Style systemStyle;
    private static Style errorStyle;
    private static Style protocolStyle;
    private static Style urlStyle;
    private String userHereName = "";
    private String userThereName = "";
    public static final BitSet URL_SEPARATORS;

    public ChatWindow(Game game) {
        this.init();
    }

    private void init() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add((Component)this.toolbar, "North");
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(ChatWindow.getButton(StartServerAction.getInstance()));
        this.toolbar.add(ChatWindow.getButton(ConnectToAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(ChatWindow.getButton(TerminateConnectionAction.getInstance()));
        this.panel.add((Component)new JScrollPane(this.pane), "Center");
        this.pane.setFont(new Font("SansSerif", 1, 13));
        this.pane.setEditable(true);
        Swinger.addKeyActions(this.inputField);
        this.inputField.setDocument(new LimitedPlainDocument(".{0,120}"));
        this.inputField.addKeyListener(new EnterListener());
        this.pane.addMouseMotionListener(new MouseMoveAdapter());
        this.pane.addMouseListener(new MouseEventsAdapter());
        this.panel.add((Component)this.inputField, "South");
        this.pane.setPreferredSize(new Dimension(300, 200));
        this.createDefaultStyles();
    }

    private static AbstractButton getButton(Action action) {
        return DamaqUI.getButton(action, DamaqUI.getButtonDimension());
    }

    public final JComponent getComponent() {
        return this.panel;
    }

    public final String getCode() {
        return CODE;
    }

    public final void onToolInit(JInternalFrame jInternalFrame) {
        this.damExManager.addDamExchangeMsgListener(this);
        this.damExManager.getProvider().addConnectionListener(this);
    }

    public final void onToolStart() {
    }

    public void onToolClosing() {
        ShowChatWindowAction showChatWindowAction = ShowChatWindowAction.getInstance();
        if (showChatWindowAction.isSelected()) {
            showChatWindowAction.actionPerformed(null);
        }
    }

    public final void onToolDestroy() {
        this.damExManager.removeDamExchangeMsgListener(this);
        this.damExManager.getProvider().removeConnectionListener(this);
    }

    public final String getTitle() {
        return Lng.getLabel("ChatWindow");
    }

    public final Icon getIcon() {
        return (Icon)ShowChatWindowAction.getInstance().getValue("SmallIcon");
    }

    public void setToolbarVisible(boolean bl) {
        this.toolbar.setVisible(bl);
    }

    public void messageReceived(DamExchangeMsgEvent damExchangeMsgEvent) {
        if (damExchangeMsgEvent.getDamExMessage().getCode() == 'C') {
            if (damExchangeMsgEvent.isSent()) {
                this.insertSentChatMessage(((ChatMessage)damExchangeMsgEvent.getDamExMessage()).getMessage());
            } else {
                this.insertReceivedChatMessage(((ChatMessage)damExchangeMsgEvent.getDamExMessage()).getMessage());
            }
            return;
        }
        this.insertProtocolMessage(damExchangeMsgEvent.isSent(), damExchangeMsgEvent.getDamExMessage().toString());
    }

    private void insertLineMessage(String string, Style style) {
        try {
            if (this.document.getLength() == 0) {
                this.document.setLogicalStyle(0, normalStyle);
                this.document.insertString(0, string, style);
                this.document.insertString(this.document.getLength(), "\n", normalStyle);
            } else {
                this.document.insertString(this.document.getLength() - 1, "\n" + string, style);
            }
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
        this.grabURLS(string);
        this.scrollDown(true);
    }

    private void scrollDown(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChatWindow.this.pane.scrollRectToVisible(ChatWindow.this.scrollRect);
                }
            });
        } else {
            this.pane.scrollRectToVisible(this.scrollRect);
        }
    }

    private void grabURLS(String string) {
        int n;
        String string2;
        int n2;
        int n3 = -7;
        int n4 = string.length();
        boolean bl = false;
        while ((n3 = string.indexOf("http://", n3 + 7)) != -1) {
            for (n2 = n3 + 6; n2 < n4 && !URL_SEPARATORS.get(string.charAt(n2)); ++n2) {
            }
            string2 = string.substring(n3, n2);
            if (string2.length() <= 10) continue;
            urlStyle.addAttribute("url", string2);
            n = n3 + this.document.getLength() - string.length() - 1;
            urlStyle.addAttribute("position", n);
            this.document.setCharacterAttributes(n, string2.length(), urlStyle, true);
            bl = true;
        }
        if (!bl) {
            n3 = -4;
            while ((n3 = string.indexOf("www.", n3 + 4)) != -1) {
                for (n2 = n3 + 3; n2 < n4 && !URL_SEPARATORS.get(string.charAt(n2)); ++n2) {
                }
                string2 = string.substring(n3, n2);
                if (string2.length() <= 7) continue;
                urlStyle.addAttribute("url", string2);
                n = n3 + this.document.getLength() - string.length() - 1;
                urlStyle.addAttribute("position", n);
                this.document.setCharacterAttributes(n, string2.length(), urlStyle, false);
            }
        }
    }

    private void insertMessageServer(String string) {
        this.insertLineMessage(string, systemStyle);
    }

    private void insertMessageClient(String string) {
        this.insertLineMessage(string, systemStyle);
    }

    private void insertSentChatMessage(String string) {
        this.insertLineMessage(this.userHereName + ":" + string, messageStyleOut);
    }

    private void insertReceivedChatMessage(String string) {
        this.insertLineMessage(this.userThereName + ":" + string, messageStyleIn);
    }

    private void insertError(String string) {
        this.insertLineMessage("Error - " + string, errorStyle);
    }

    private void insertProtocolMessage(boolean bl, String string) {
        this.insertLineMessage((bl ? ">" : "<") + string, protocolStyle);
    }

    public void onSocketEvent(ConnectionEvent connectionEvent) {
        switch (connectionEvent.getId()) {
            case SERVER_INIT: {
                this.insertMessageServer("Initializing server...");
                break;
            }
            case SERVER_STARTED: {
                ServerSocket serverSocket = ((ServerConnection)connectionEvent.getConnectionSocket()).getServerSocket();
                InetAddress inetAddress = serverSocket.getInetAddress();
                String string = inetAddress == null ? this.getLocalhost() : (inetAddress.getHostAddress() != null && inetAddress.getHostAddress().equals("0.0.0.0") ? this.getLocalhost() : inetAddress.getHostAddress());
                this.insertMessageServer("Started server on port " + serverSocket.getLocalPort() + ", " + string);
                break;
            }
            case SERVER_ACCEPT: {
                this.insertMessageServer("Connection attempt...");
                break;
            }
            case CLIENT_CONNECT: {
                Socket socket = connectionEvent.getConnectionSocket().getSocket();
                this.insertMessageServer("Client connected from " + socket.getInetAddress());
                break;
            }
            case CLIENT_DISCONNECT: {
                this.insertMessageServer("Client disconnected");
                break;
            }
            case SERVER_CLOSED: {
                this.insertMessageServer("Server closed");
                break;
            }
            case CONNECTING: {
                this.insertMessageClient("Connecting ...");
                break;
            }
            case CONNECT: {
                this.insertMessageClient("Succesfully connected");
                break;
            }
            case DISCONNECT: {
                this.insertMessageClient("Disconnected.");
                break;
            }
            case CLIENT_CLOSED: {
                this.insertMessageClient("Connection was closed.");
            }
        }
    }

    private String getLocalhost() {
        String string;
        try {
            string = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return string;
    }

    public void onError(ConnectionEvent connectionEvent, IOException iOException) {
        if (iOException instanceof UnknownHostException) {
            this.insertError("Internetove spojeni neni k dispozici");
        }
        this.insertError(iOException.getMessage());
    }

    public void onMessage(ConnectionEvent connectionEvent, String string) {
    }

    private void createDefaultStyles() {
        normalStyle = this.sc.addStyle("normal", null);
        StyleConstants.setFontSize(normalStyle, 13);
        StyleConstants.setFontFamily(normalStyle, this.pane.getFont().getFamily());
        StyleConstants.setBold(normalStyle, true);
        messageStyleOut = this.sc.addStyle("messageout", normalStyle);
        messageStyleIn = this.sc.addStyle("messagein", normalStyle);
        errorStyle = this.sc.addStyle("error", normalStyle);
        protocolStyle = this.sc.addStyle("protocol", normalStyle);
        systemStyle = this.sc.addStyle("system", normalStyle);
        urlStyle = this.sc.addStyle("url", normalStyle);
        StyleConstants.setUnderline(urlStyle, true);
        StyleConstants.setForeground(normalStyle, Color.BLACK);
        StyleConstants.setForeground(errorStyle, Color.RED);
        StyleConstants.setForeground(protocolStyle, Color.MAGENTA);
        StyleConstants.setForeground(messageStyleOut, Color.ORANGE);
        StyleConstants.setForeground(messageStyleIn, Color.GREEN);
        StyleConstants.setForeground(systemStyle, Color.DARK_GRAY);
        StyleConstants.setForeground(urlStyle, Color.BLUE);
    }

    public void clearScreen() {
        try {
            this.pane.getDocument().remove(0, this.pane.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    private void textAreaMouseMoved(MouseEvent mouseEvent) {
        if (this.document.getCharacterElement(this.pane.viewToModel(mouseEvent.getPoint())).getAttributes().getAttribute("url") != null) {
            if (this.pane.getCursor().getType() != 12) {
                this.pane.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.pane.getCursor().getType() != 0) {
            this.pane.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void labelMouseClicked(MouseEvent mouseEvent) {
        if (((JComponent)mouseEvent.getSource()).getCursor().getType() == 12) {
            BrowserControl.showURL((String)this.document.getCharacterElement(this.pane.viewToModel(mouseEvent.getPoint())).getAttributes().getAttribute("url"));
            this.pane.invalidate();
            this.pane.repaint();
            mouseEvent.consume();
        }
    }

    static {
        URL_SEPARATORS = new BitSet(256);
        URL_SEPARATORS.set(32);
        URL_SEPARATORS.set(10);
        URL_SEPARATORS.set(44);
        URL_SEPARATORS.set(9);
        URL_SEPARATORS.set(33);
        URL_SEPARATORS.set(59);
        URL_SEPARATORS.set(42);
        URL_SEPARATORS.set(41);
        URL_SEPARATORS.set(40);
        URL_SEPARATORS.set(94);
        URL_SEPARATORS.set(91);
        URL_SEPARATORS.set(93);
        URL_SEPARATORS.set(60);
        URL_SEPARATORS.set(62);
        URL_SEPARATORS.set(123);
        URL_SEPARATORS.set(125);
    }

    private final class MouseEventsAdapter
    extends MouseAdapter {
        private MouseEventsAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ChatWindow.this.labelMouseClicked(mouseEvent);
        }
    }

    private final class MouseMoveAdapter
    extends MouseMotionAdapter {
        private MouseMoveAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ChatWindow.this.textAreaMouseMoved(mouseEvent);
        }
    }

    private class EnterListener
    extends KeyAdapter {
        private EnterListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                String string = ChatWindow.this.inputField.getText();
                if (string != null && string.length() > 0) {
                    ChatWindow.this.damExManager.sendChatMessage(string);
                    ChatWindow.this.inputField.setText("");
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

