/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.editor;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.damaq.core.Lng;
import net.damaq.core.actions.EditorModeAction;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.boardtools.AbstractBoardTool;
import net.damaq.core.boardtools.editor.BlacksToMoveAction;
import net.damaq.core.boardtools.editor.BtnSelectBKAction;
import net.damaq.core.boardtools.editor.BtnSelectBPAction;
import net.damaq.core.boardtools.editor.BtnSelectWKAction;
import net.damaq.core.boardtools.editor.BtnSelectWPAction;
import net.damaq.core.boardtools.editor.EmptyPositionAction;
import net.damaq.core.boardtools.editor.RestoreBoardAction;
import net.damaq.core.boardtools.editor.StartingPositionAction;
import net.damaq.core.boardtools.editor.WhitesToMoveAction;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.DamaqUI;
import net.damaq.core.swing.JButtonGroup;
import net.damaq.gamestyle.Piece;
import net.damaq.gui.LookAndFeels;
import net.damaq.gui.Skin;
import net.damaq.gui.ToolbarSeparator;

public final class Editor
extends AbstractBoardTool
implements ChangeListener {
    public static final String CODE = Editor.class.getSimpleName();
    private final JPanel panel = new JPanel(new BorderLayout());
    private JToolBar toolbar;
    private JInternalFrame internalFrame;
    private JToggleButton btnSelWK;
    private JToggleButton btnSelWP;
    private JToggleButton btnSelBK;
    private JToggleButton btnSelBP;

    public Editor() {
        this.init();
    }

    private void init() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add((Component)this.toolbar, "North");
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(Editor.getButton(StartingPositionAction.getInstance()));
        this.toolbar.add(Editor.getButton(EmptyPositionAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        JButtonGroup jButtonGroup = new JButtonGroup();
        JToggleButton jToggleButton = Editor.getToggleButton(WhitesToMoveAction.getInstance());
        jButtonGroup.add(jToggleButton);
        this.toolbar.add(jToggleButton);
        jToggleButton = Editor.getToggleButton(BlacksToMoveAction.getInstance());
        jButtonGroup.add(jToggleButton);
        this.toolbar.add(jToggleButton);
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Editor.getButton(RestoreBoardAction.getInstance()));
        RestoreBoardAction.getInstance().saveCurrentBoard();
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0, -2.0, -1.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        JPanel jPanel = new JPanel(tableLayout);
        jButtonGroup = new JButtonGroup();
        this.btnSelBP = DamaqUI.getToggleButton(BtnSelectBPAction.getInstance());
        jButtonGroup.add(this.btnSelBP);
        jPanel.add((Component)this.btnSelBP, new CustomLayoutConstraints(2, 0));
        this.btnSelWK = DamaqUI.getToggleButton(BtnSelectWKAction.getInstance());
        jButtonGroup.add(this.btnSelWK);
        jPanel.add((Component)this.btnSelWK, new CustomLayoutConstraints(1, 1));
        this.btnSelBK = DamaqUI.getToggleButton(BtnSelectBKAction.getInstance());
        jButtonGroup.add(this.btnSelBK);
        jPanel.add((Component)this.btnSelBK, new CustomLayoutConstraints(2, 1));
        this.btnSelWP = DamaqUI.getToggleButton(BtnSelectWPAction.getInstance());
        jPanel.add((Component)this.btnSelWP, new CustomLayoutConstraints(1, 0));
        jButtonGroup.add(this.btnSelWP);
        if (jButtonGroup.getSelected() == null) {
            BtnSelectWPAction.getInstance().setSelected(true);
        }
        Editor.updateActions(true);
        this.panel.add((Component)jPanel, "Center");
        this.stateChanged(null);
    }

    private static void updateActions(boolean bl) {
        StartingPositionAction.getInstance().setEnabled(bl);
        EmptyPositionAction.getInstance().setEnabled(bl);
        BtnSelectBPAction.getInstance().setEnabled(bl);
        BtnSelectWKAction.getInstance().setEnabled(bl);
        BtnSelectBKAction.getInstance().setEnabled(bl);
        BtnSelectWPAction.getInstance().setEnabled(bl);
        BlacksToMoveAction.getInstance().setEnabled(bl);
        WhitesToMoveAction.getInstance().setEnabled(bl);
        RestoreBoardAction.getInstance().setEnabled(bl);
    }

    private static AbstractButton getButton(Action action) {
        return DamaqUI.getButton(action, DamaqUI.getButtonDimension());
    }

    public final JComponent getComponent() {
        return this.panel;
    }

    public final String getCode() {
        return CODE;
    }

    public final void onToolInit(JInternalFrame jInternalFrame) {
        this.internalFrame = jInternalFrame;
        LookAndFeels.getInstance().addChangeListener(this);
    }

    public final void onToolStart() {
    }

    public void setToolbarVisible(boolean bl) {
        this.toolbar.setVisible(bl);
        this.internalFrame.pack();
    }

    public final void onToolDestroy() {
        EditorModeAction editorModeAction = EditorModeAction.getInstance();
        if (editorModeAction.isSelected()) {
            editorModeAction.actionPerformed(null);
        }
        Editor.updateActions(false);
        LookAndFeels.getInstance().removeChangeListener(this);
        this.internalFrame = null;
    }

    public final String getTitle() {
        return Lng.getLabel("Editor");
    }

    private static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction) {
        return DamaqUI.getToggleButton(selectableCoreAction, DamaqUI.getButtonDimension());
    }

    public final Icon getIcon() {
        return (Icon)EditorModeAction.getInstance().getValue("SmallIcon");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Skin skin = LookAndFeels.getInstance().getActiveSkin();
        this.btnSelBK.setIcon(new ImageIcon(skin.getPieceImage(Piece.BLACK_KING)));
        this.btnSelBP.setIcon(new ImageIcon(skin.getPieceImage(Piece.BLACK_PIECE)));
        this.btnSelWK.setIcon(new ImageIcon(skin.getPieceImage(Piece.WHITE_KING)));
        this.btnSelWP.setIcon(new ImageIcon(skin.getPieceImage(Piece.WHITE_PIECE)));
        if (this.internalFrame != null) {
            this.internalFrame.pack();
        }
    }
}

