/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.history;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.MaskFormatter;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.actions.ShowHistoryAction;
import net.damaq.core.boardtools.AbstractBoardTool;
import net.damaq.core.boardtools.history.JumpToAction;
import net.damaq.core.boardtools.history.JumpToEndAction;
import net.damaq.core.boardtools.history.JumpToNextAction;
import net.damaq.core.boardtools.history.JumpToPreviousAction;
import net.damaq.core.boardtools.history.JumpToStartAction;
import net.damaq.core.boardtools.history.ShowCommentsAction;
import net.damaq.core.boardtools.history.ShowInfoTableAction;
import net.damaq.core.boardtools.history.ShowLongMovesAction;
import net.damaq.core.boardtools.history.StringActionTableCellEditor;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStyleManager;
import net.damaq.core.managers.HistoryEvent;
import net.damaq.core.managers.HistoryItem;
import net.damaq.core.managers.HistoryManager;
import net.damaq.core.managers.interfaces.HistoryListener;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.DamaqUI;
import net.damaq.core.swing.RecentsComboModel;
import net.damaq.core.swing.SpinnerEditor;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gui.ToolbarSeparator;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNSection;
import net.damaq.utilities.SwingerUtils;

public final class History
extends AbstractBoardTool
implements HistoryListener,
TableModelListener,
ChangeListener {
    public static final String CODE = History.class.getSimpleName();
    private final JPanel panel = new JPanel();
    private GameTableModel model;
    private GameInfoModel infoModel = new GameInfoModel();
    private final Game game;
    private boolean longMoves;
    private static final Font moveFont = new Font("Monospaced", 1, 13);
    private static final Font numberFont = moveFont.deriveFont(0);
    private static final Font commentFont = new Font("SansSerif", 0, 12);
    private static final Font infoFont = new Font("SansSerif", 1, 12);
    private JTable table;
    private JTable infoTable;
    private int activeRow = -1;
    private int activeColumn = -1;
    private static final Dimension playDimensionSize = new Dimension(38, 28);
    private AbstractButton btnJumpStart;
    private AbstractButton btnJumpStepBack;
    private AbstractButton btnJumpStepForward;
    private AbstractButton btnJumpEnd;
    private static final int ROW = 0;
    private static final int COLUMN = 1;
    private TableColumn removedWCommentColumn = null;
    private TableColumn removedBCommentColumn = null;
    private SelectableCoreAction showLongMovesAction = null;
    private SelectableCoreAction showCommentsAction = null;
    private JToolBar toolbar;

    public History(Game game) {
        this.game = game;
        this.init();
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(new double[]{-1.0}, new double[]{-2.0, -2.0, -1.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        this.panel.setLayout(tableLayout);
        this.infoTable = new InfoTable();
        this.infoTable.setCellSelectionEnabled(true);
        this.infoTable.setColumnSelectionAllowed(false);
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.infoTable.getSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        this.infoTable.setTableHeader(null);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setFont(infoFont);
                return component;
            }
        };
        this.infoModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        SwingerUtils.updateColumn(this.infoTable, defaultTableCellRenderer, 0, 40);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        SwingerUtils.updateColumn(this.infoTable, defaultTableCellRenderer, 1, 80);
        this.updateInfoData();
        this.infoModel.addTableModelListener(this);
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add((Component)this.toolbar, new CustomLayoutConstraints(0, 0));
        this.panel.add((Component)this.infoTable, new CustomLayoutConstraints(0, 1));
        this.panel.setPreferredSize(new Dimension(220, 350));
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.longMoves = AppPrefs.getProperty("longMovesHistory", true);
        ShowInfoTableAction showInfoTableAction = new ShowInfoTableAction(this);
        this.toolbar.add(History.getToggleButton(showInfoTableAction));
        this.toolbar.add(new ToolbarSeparator());
        this.showLongMovesAction = new ShowLongMovesAction(this);
        this.toolbar.add(History.getToggleButton(this.showLongMovesAction));
        this.toolbar.add(new ToolbarSeparator());
        this.showCommentsAction = new ShowCommentsAction(this);
        this.toolbar.add(History.getToggleButton(this.showCommentsAction));
        TableLayout tableLayout2 = new TableLayout(new double[]{-1.0, -2.0, -2.0, -2.0, -2.0, -1.0}, new double[]{-2.0});
        tableLayout2.setHGap(3);
        tableLayout2.setVGap(2);
        JPanel jPanel = new JPanel(tableLayout2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnJumpStart = History.getButton(new JumpToStartAction());
        this.btnJumpStepBack = History.getButton(new JumpToPreviousAction());
        this.btnJumpStepForward = History.getButton(new JumpToNextAction());
        this.btnJumpEnd = History.getButton(new JumpToEndAction());
        jPanel.add((Component)this.btnJumpStart, new CustomLayoutConstraints(1, 0));
        jPanel.add((Component)this.btnJumpStepBack, new CustomLayoutConstraints(2, 0));
        jPanel.add((Component)this.btnJumpStepForward, new CustomLayoutConstraints(3, 0));
        jPanel.add((Component)this.btnJumpEnd, new CustomLayoutConstraints(4, 0));
        this.model = new GameTableModel(this.game.getManager());
        this.model.initAll(this.game.getHistoryManager());
        this.model.setColumnIdentifiers(new Object[]{Lng.getLabel("history.column1"), Lng.getLabel("history.column2"), Lng.getLabel("history.column3"), Lng.getLabel("history.column4"), Lng.getLabel("history.column5")});
        this.table = new JTable(this.model){

            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.table.setColumnSelectionAllowed(false);
        DefaultListSelectionModel defaultListSelectionModel2 = (DefaultListSelectionModel)this.table.getSelectionModel();
        defaultListSelectionModel2.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        this.table.setDefaultEditor(Object.class, new StringActionTableCellEditor(this.table.getDefaultEditor(Object.class)));
        this.table.addMouseListener(new MouseClickAdapter());
        TableColumn tableColumn = SwingerUtils.updateColumn(this.table, new NumberRenderer(), 0, 50);
        tableColumn.setMaxWidth(50);
        tableColumn.setResizable(false);
        MoveRenderer moveRenderer = new MoveRenderer();
        SwingerUtils.updateColumn(this.table, moveRenderer, 1, 40);
        SwingerUtils.updateColumn(this.table, moveRenderer, 3, 40);
        CommentRenderer commentRenderer = new CommentRenderer();
        SwingerUtils.updateColumn(this.table, commentRenderer, 2, 40);
        SwingerUtils.updateColumn(this.table, commentRenderer, 4, 40);
        this.table.setFont(new Font("Monospaced", 1, 12));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.table);
        this.panel.add((Component)jScrollPane, new CustomLayoutConstraints(0, 2));
        this.panel.add((Component)jPanel, new CustomLayoutConstraints(0, 3));
        boolean bl = AppPrefs.getProperty("showComments", true);
        if (!bl) {
            this.showComments(false);
        }
        this.showInfoTable(showInfoTableAction.isSelected());
        this.selectActive();
        this.game.getHistoryManager().addHistoryListener(this);
        this.game.getGameInfoManager().addChangeListener(this);
        this.model.addTableModelListener(this);
    }

    private void updateInfoData() {
        PDNGame pDNGame = this.game.getGameInfoManager().getPdnGame();
        this.infoModel.updateInfoData(pDNGame);
    }

    private HistoryItem getJumpHistoryItem(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return null;
        }
        if (n == 0) {
            n = 1;
        }
        if (History.isColumnMoveType(n) && n2 < this.model.getRowCount()) {
            MoveItem moveItem = (MoveItem)this.model.getValueAt(n2, n);
            if (moveItem != null && moveItem.getHistoryItem().isFirstEmpty()) {
                n = 3;
            }
            if ((n != this.activeColumn || n2 != this.activeRow) && (moveItem = (MoveItem)this.model.getValueAt(n2, n)) != null) {
                return moveItem.getHistoryItem();
            }
        }
        return null;
    }

    public final JComponent getComponent() {
        return this.panel;
    }

    public final String getCode() {
        return CODE;
    }

    private void update() {
        this.model.updateAll();
    }

    public final void onToolInit(JInternalFrame jInternalFrame) {
    }

    public final void onToolStart() {
    }

    public final void onToolDestroy() {
        this.game.getHistoryManager().removeHistoryListener(this);
        this.game.getGameInfoManager().removeChangeListener(this);
        this.infoModel.removeTableModelListener(this);
        ShowHistoryAction.getInstance().setSelected(false);
        this.model.removeTableModelListener(this);
        this.model.setRowCount(0);
        this.infoModel.setRowCount(0);
        this.infoModel = null;
        this.model = null;
    }

    public final String getTitle() {
        return Lng.getLabel("history");
    }

    public final void showLongMoves(boolean bl) {
        if (this.longMoves != bl) {
            this.longMoves = bl;
            this.update();
        }
    }

    public final void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource().equals(this.infoModel)) {
            String string;
            switch (tableModelEvent.getFirstRow()) {
                case 1: {
                    string = "BLACK";
                    break;
                }
                case 0: {
                    string = "WHITE";
                    break;
                }
                case 4: {
                    string = "DATE";
                    break;
                }
                case 2: {
                    string = "EVENT";
                    break;
                }
                case 5: {
                    string = "ROUND";
                    break;
                }
                case 3: {
                    string = "SITE";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (string != null) {
                this.game.getGameInfoManager().getPdnGame().addSection(string, this.infoModel.getValueAt(tableModelEvent.getFirstRow(), 1).toString());
            } else assert (false);
        } else {
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getType() == 0 && History.isColumnCommentType(n)) {
                MoveItem moveItem = (MoveItem)this.model.getValueAt(tableModelEvent.getLastRow(), n - 1);
                if (moveItem != null) {
                    moveItem.getHistoryItem().setComment((String)this.model.getValueAt(tableModelEvent.getLastRow(), n));
                }
                return;
            }
            this.selectActive();
        }
    }

    private static boolean isColumnMoveType(int n) {
        return n == 3 || n == 1;
    }

    private static boolean isColumnCommentType(int n) {
        return n == 4 || n == 2;
    }

    private void selectActive() {
        int n;
        int[] nArray;
        int n2 = this.model.getRowCount();
        if (n2 > 0 && (nArray = this.model.indexToRowColumn(n = this.game.getHistoryManager().getLastActiveIndex()))[0] < n2) {
            this.activeColumn = this.table.convertColumnIndexToView(nArray[1]);
            this.activeRow = nArray[0];
            this.table.changeSelection(this.activeRow, nArray[1], false, false);
            if (!SwingerUtils.isCellVisible(this.table, this.activeRow, nArray[1])) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        History.this.table.repaint();
                        SwingerUtils.scrollToVisible(History.this.table, History.this.activeRow, nArray[1]);
                    }
                });
            }
        }
    }

    public final void showComments(boolean bl) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (bl) {
            if (this.removedBCommentColumn != null && this.removedWCommentColumn != null) {
                tableColumnModel.addColumn(this.removedWCommentColumn);
                tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, 2);
                tableColumnModel.addColumn(this.removedBCommentColumn);
                tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, 4);
                this.selectActive();
            }
        } else {
            this.removedWCommentColumn = tableColumnModel.getColumn(2);
            this.removedBCommentColumn = tableColumnModel.getColumn(4);
            tableColumnModel.removeColumn(this.removedWCommentColumn);
            tableColumnModel.removeColumn(this.removedBCommentColumn);
        }
    }

    public final void showInfoTable(boolean bl) {
        this.infoTable.setVisible(bl);
        if (bl) {
            ((TableLayout)this.panel.getLayout()).setRow(1, -2.0);
        } else {
            ((TableLayout)this.panel.getLayout()).setRow(1, 0.0);
        }
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        this.updateInfoData();
    }

    public final void historyFlowChanged(HistoryEvent historyEvent) {
        HistoryManager historyManager = (HistoryManager)historyEvent.getSource();
        switch (historyEvent.getType()) {
            case ADD: {
                this.model.add(historyManager, historyEvent.getChangeStart(), historyEvent.getChangeEnd());
                break;
            }
            case REMOVE: {
                this.model.remove(historyEvent.getChangeStart(), historyEvent.getChangeEnd());
                break;
            }
            case REMOVEALL: {
                this.model.removeAll();
                break;
            }
            case UPDATE: {
                this.model.update(historyEvent.getChangeStart(), historyEvent.getChangeEnd());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!historyEvent.isValueAdjusting()) {
            this.updateButtons(historyManager);
        }
    }

    private void updateButtons(HistoryManager historyManager) {
        boolean bl = historyManager.canUndo();
        this.btnJumpStart.setEnabled(bl);
        this.btnJumpStepBack.setEnabled(bl);
        boolean bl2 = historyManager.canRedo();
        this.btnJumpStepForward.setEnabled(bl2);
        this.btnJumpEnd.setEnabled(bl2);
    }

    public final Icon getIcon() {
        return (Icon)ShowHistoryAction.getInstance().getValue("SmallIcon");
    }

    private static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction) {
        return DamaqUI.getToggleButton(selectableCoreAction, DamaqUI.getButtonDimension());
    }

    private static AbstractButton getButton(Action action) {
        AbstractButton abstractButton = DamaqUI.getButton(action, playDimensionSize);
        abstractButton.setFocusable(true);
        return abstractButton;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl) {
            ((TableLayout)this.panel.getLayout()).setRow(0, -2.0);
        } else {
            ((TableLayout)this.panel.getLayout()).setRow(0, 0.0);
        }
        this.toolbar.setVisible(bl);
    }

    private final class InfoTable
    extends JTable {
        private TableCellEditor spinnerEditor;
        private TableCellEditor comboEditor;
        private TableCellEditor dateEditor;

        public InfoTable() {
            super(History.this.infoModel);
        }

        public final TableCellEditor getCellEditor(int n, int n2) {
            TableCellEditor tableCellEditor;
            switch (n) {
                case 5: {
                    tableCellEditor = this.getSpinnerEditor();
                    break;
                }
                case 2: {
                    tableCellEditor = this.getComboEditor("prevEvents");
                    break;
                }
                case 3: {
                    tableCellEditor = this.getComboEditor("prevSite");
                    break;
                }
                case 0: {
                    tableCellEditor = this.getComboEditor("prevWhite");
                    break;
                }
                case 1: {
                    tableCellEditor = this.getComboEditor("prevBlack");
                    break;
                }
                case 4: {
                    tableCellEditor = this.getDateEditor();
                    break;
                }
                default: {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
            }
            return tableCellEditor;
        }

        private TableCellEditor getDateEditor() {
            if (this.dateEditor == null) {
                MaskFormatter maskFormatter;
                try {
                    maskFormatter = new MaskFormatter("****.**.**");
                }
                catch (ParseException parseException) {
                    maskFormatter = new MaskFormatter();
                }
                this.dateEditor = new DefaultCellEditor(new JFormattedTextField(maskFormatter));
            }
            return this.dateEditor;
        }

        private TableCellEditor getSpinnerEditor() {
            return this.spinnerEditor == null ? (this.spinnerEditor = new SpinnerEditor(new SpinnerNumberModel(1, 1, 30, 1))) : this.spinnerEditor;
        }

        private TableCellEditor getComboEditor(String string) {
            if (this.comboEditor == null) {
                JComboBox jComboBox = new JComboBox(new RecentsComboModel(string, true));
                jComboBox.setFont(jComboBox.getFont().deriveFont(0));
                SwingerUtils.addKeyActionsForCombobox(jComboBox);
                jComboBox.setEditable(true);
                this.comboEditor = new DefaultCellEditor(jComboBox);
            } else {
                ((JComboBox)((DefaultCellEditor)this.comboEditor).getComponent()).setModel(new RecentsComboModel(string, true));
                this.repaint();
            }
            return this.comboEditor;
        }
    }

    private static final class GameInfoModel
    extends DefaultTableModel {
        private static final int WHITE_ROW = 0;
        private static final int BLACK_ROW = 1;
        private static final int EVENT_ROW = 2;
        private static final int SITE_ROW = 3;
        private static final int DATE_ROW = 4;
        private static final int ROUND_ROW = 5;

        public GameInfoModel() {
            this.setColumnIdentifiers(new Object[]{"section", "value"});
            this.setRowCount(6);
            this.setValueAt(Lng.getLabel("history.info.column1"), 0, 0);
            this.setValueAt(Lng.getLabel("history.info.column2"), 1, 0);
            this.setValueAt(Lng.getLabel("history.info.column3"), 2, 0);
            this.setValueAt(Lng.getLabel("history.info.column4"), 3, 0);
            this.setValueAt(Lng.getLabel("history.info.column5"), 4, 0);
            this.setValueAt(Lng.getLabel("history.info.column6"), 5, 0);
        }

        public final void updateInfoData(PDNGame pDNGame) {
            int n;
            this.setValueAt(this.getValue(pDNGame.getWhiteSection()), 0, 1);
            this.setValueAt(this.getValue(pDNGame.getBlackSection()), 1, 1);
            this.setValueAt(this.getValue(pDNGame.getEventSection()), 2, 1);
            this.setValueAt(this.getValue(pDNGame.getSiteSection()), 3, 1);
            this.setValueAt(this.getValue(pDNGame.getDateSection()), 4, 1);
            try {
                n = pDNGame.getRoundSection() == null ? 1 : Integer.valueOf(pDNGame.getRoundSection().getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
            this.setValueAt(pDNGame.getRoundSection() == null ? 1 : n, 5, 1);
        }

        public final boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        private String getValue(PDNSection pDNSection) {
            return pDNSection == null ? "" : pDNSection.getStringValue();
        }
    }

    private final class MouseClickAdapter
    extends MouseAdapter {
        private MouseClickAdapter() {
        }

        public final void mouseClicked(final MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                HistoryItem historyItem = History.this.getJumpHistoryItem(History.this.table.convertColumnIndexToModel(History.this.table.getSelectedColumn()), History.this.table.getSelectedRow());
                if (historyItem != null) {
                    this.jumpInHistory(historyItem);
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        new ContextMenu().show(History.this.table, mouseEvent.getPoint());
                    }
                });
                mouseEvent.consume();
            }
        }

        private void jumpInHistory(HistoryItem historyItem) {
            new JumpToAction(historyItem).actionPerformed(null);
        }
    }

    private final class ContextMenu
    extends JPopupMenu {
        private ContextMenu() {
        }

        public final void show(JTable jTable, Point point) {
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.convertColumnIndexToModel(jTable.columnAtPoint(point));
            HistoryItem historyItem = null;
            if (n >= 0 && n2 >= 0 && !History.this.model.isCellEditable(n, n2)) {
                historyItem = History.this.getJumpHistoryItem(n2, n);
            }
            JumpToAction jumpToAction = new JumpToAction(historyItem);
            jumpToAction.setEnabled(historyItem != null);
            this.add(jumpToAction);
            this.addSeparator();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, History.this.showLongMovesAction);
            this.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, History.this.showCommentsAction);
            this.add(jCheckBoxMenuItem);
            super.show(jTable, point.x, point.y);
        }
    }

    private final class GameTableModel
    extends DefaultTableModel {
        private static final int COL_COUNTER = 0;
        private static final int COL_WHITE_MOVE = 1;
        private static final int COL_WHITE_MOVE_COMMENT = 2;
        private static final int COL_BLACK_MOVE = 3;
        private static final int COL_BLACK_MOVE_COMMENT = 4;
        private final GameStyleManager manager;

        public GameTableModel(GameStyleManager gameStyleManager) {
            super(0, 5);
            this.manager = gameStyleManager;
        }

        public final void initAll(HistoryManager historyManager) {
            int n = historyManager.getSize();
            this.add(historyManager, 0, n - 1);
            History.this.updateButtons(historyManager);
        }

        public final synchronized void add(HistoryManager historyManager, int n, int n2) {
            if (historyManager.getSize() > 0) {
                for (int i = n; i <= n2; ++i) {
                    int[] nArray = this.indexToRowColumn(i);
                    HistoryItem historyItem = historyManager.getItem(i);
                    this.storeValueAt(historyItem, nArray[0], nArray[1]);
                }
            }
        }

        public final synchronized void remove(int n, int n2) {
            for (int i = n2; i >= n; --i) {
                int[] nArray = this.indexToRowColumn(i);
                if (nArray[1] == 3) {
                    this.setValueAt(null, nArray[0], nArray[1] + 1);
                    this.setValueAt(null, nArray[0], nArray[1]);
                    continue;
                }
                this.removeRow(nArray[0]);
            }
        }

        private void storeValueAt(HistoryItem historyItem, int n, int n2) {
            this.addRows(n);
            this.setValueAt(new MoveItem(this.manager.getCurrentGameStyle(), historyItem, History.this.longMoves), n, n2);
            this.setValueAt(historyItem.getComment(), n, n2 + 1);
        }

        private int[] indexToRowColumn(int n) {
            return new int[]{n / 2, (n & 1) == 0 ? 1 : 3};
        }

        private void addRows(int n) {
            for (int i = this.getRowCount(); i <= n; ++i) {
                Object[] objectArray = new Object[5];
                objectArray[0] = SwingerUtils.matchSpaces(4, i + 1, true);
                this.addRow(objectArray);
            }
        }

        public final boolean isCellEditable(int n, int n2) {
            return History.isColumnCommentType(n2) && this.getValueAt(n, n2 - 1) != null;
        }

        public final synchronized void update(int n, int n2) {
            int n3 = this.indexToRowColumn(n2)[0];
            int n4 = this.indexToRowColumn(n)[0];
            for (int i = n2; i >= n; --i) {
                int[] nArray = this.indexToRowColumn(i);
                MoveItem moveItem = (MoveItem)this.getValueAt(nArray[0], nArray[1]);
                moveItem.updateValue(History.this.longMoves);
                Vector vector = (Vector)this.dataVector.elementAt(nArray[0]);
                vector.setElementAt(moveItem.getHistoryItem().getComment(), nArray[1] + 1);
            }
            this.fireTableRowsUpdated(n4, n3);
        }

        public final synchronized void updateAll() {
            int n = this.getRowCount();
            int n2 = n * 2;
            for (int i = 0; i < n2; ++i) {
                int[] nArray = this.indexToRowColumn(i);
                MoveItem moveItem = (MoveItem)this.getValueAt(nArray[0], nArray[1]);
                if (moveItem == null) continue;
                moveItem.updateValue(History.this.longMoves);
            }
            this.fireTableRowsUpdated(0, n - 1);
        }

        public final synchronized void removeAll() {
            int n = this.getRowCount();
            this.dataVector.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    final class MoveRenderer
    extends DefaultTableCellRenderer {
        MoveRenderer() {
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl2 && n == History.this.activeRow && n2 == History.this.activeColumn && !jTable.hasFocus()) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            }
            this.setFont(moveFont);
            if (object != null) {
                MoveItem moveItem = (MoveItem)object;
                switch (moveItem.getHistoryItem().getType()) {
                    case MOVE: {
                        this.setForeground(Color.BLACK);
                        this.setToolTipText(object.toString());
                        break;
                    }
                    case MOVE_BACK: {
                        this.setForeground(Color.GRAY);
                        this.setToolTipText(object.toString());
                        break;
                    }
                    case PROGRESS: {
                        this.setForeground(Color.GRAY);
                        this.setToolTipText(null);
                        break;
                    }
                    case FIRST_NULL: {
                        this.setForeground(Color.BLUE);
                        this.setToolTipText(null);
                        break;
                    }
                    case BLACKS_WIN: {
                        this.setForeground(Color.RED);
                        this.setToolTipText(Lng.getLabel("history.move.blackwon"));
                        break;
                    }
                    case WHITES_WIN: {
                        this.setForeground(Color.RED);
                        this.setToolTipText(Lng.getLabel("history.move.whitewon"));
                        break;
                    }
                    case DRAW: {
                        this.setForeground(Color.RED);
                        this.setToolTipText(Lng.getLabel("history.move.draw"));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            return this;
        }
    }

    static final class NumberRenderer
    extends DefaultTableCellRenderer {
        NumberRenderer() {
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setFont(numberFont);
            return this;
        }
    }

    static final class CommentRenderer
    extends DefaultTableCellRenderer {
        CommentRenderer() {
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setFont(commentFont);
            if (object != null) {
                this.setToolTipText("<html>" + object.toString().replaceAll("\n", "<br>") + "</html>");
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private static final class MoveItem {
        private static final String END_DRAW = "\u00bd\u2013\u00bd";
        private static final String END_WHITES_WIN = "1\u20130";
        private static final String END_BLACKS_WIN = "0\u20131";
        private static final String NULL_MOVE = "-->";
        private static final String GAME_PROGRESS = "...";
        private HistoryItem item = null;
        private String stringValue;
        private GameStyle style;

        public MoveItem(GameStyle gameStyle, HistoryItem historyItem, boolean bl) {
            this.item = historyItem;
            this.style = gameStyle;
            this.updateValue(bl);
        }

        private void updateValue(boolean bl) {
            switch (this.item.getType()) {
                case PROGRESS: {
                    this.stringValue = GAME_PROGRESS;
                    break;
                }
                case MOVE: 
                case MOVE_BACK: {
                    this.stringValue = this.style.toString(this.item.getMove(), bl, this.item.isJumps());
                    break;
                }
                case FIRST_NULL: {
                    this.stringValue = NULL_MOVE;
                    break;
                }
                case BLACKS_WIN: {
                    this.stringValue = END_BLACKS_WIN;
                    break;
                }
                case WHITES_WIN: {
                    this.stringValue = END_WHITES_WIN;
                    break;
                }
                case DRAW: {
                    this.stringValue = END_DRAW;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public final String toString() {
            return this.stringValue;
        }

        public final HistoryItem getHistoryItem() {
            return this.item;
        }
    }
}

