/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.history;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.actions.PlayerToMoveAction;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.HistoryItem;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.utilities.LogUtils;

abstract class JumpAction
extends BoardAction {
    private static final Logger logger = Logger.getLogger(JumpAction.class.getName());

    public JumpAction(EventType eventType, String string, KeyStroke keyStroke, String string2) {
        super(eventType, string, keyStroke, string2);
    }

    final void doJump(HistoryItem historyItem) {
        final Game game = JumpAction.getGame();
        final Board board = historyItem.getBoard();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    BoardManager boardManager = game.getManager().getBoardManager();
                    boardManager.setBoard(board);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LogUtils.processException(logger, interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogUtils.processException(logger, invocationTargetException);
        }
        game.updateActivePlayer();
        if (!game.getActivePlayer().isHuman()) {
            PlayerToMoveAction.getInstance().doAction();
            game.playersSwitched();
        }
    }
}

