/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.moves;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.actions.DoMoveAction;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.actions.ShowAvailableMovesAction;
import net.damaq.core.boardtools.AbstractBoardTool;
import net.damaq.core.boardtools.moves.ShowLongMovesAction;
import net.damaq.core.boardtools.moves.ShowSameMovesAction;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.interfaces.BoardListener;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.core.swing.DamaqUI;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvailableMoves
extends AbstractBoardTool
implements BoardListener,
ListSelectionListener,
GameStatusListener {
    public static final String CODE = AvailableMoves.class.getSimpleName();
    private final JPanel panel = new JPanel(new BorderLayout());
    private JList list;
    private final BoardManager boardManager;
    private DefaultListModel model;
    private final Game game;
    private boolean longMoves;
    private boolean sameMoves;
    private SelectableCoreAction showLongMovesAction = null;
    private ShowSameMovesAction showSameMovesAction = null;
    private JToolBar toolbar;

    public AvailableMoves(Game game) {
        this.game = game;
        this.boardManager = game.getManager().getBoardManager();
        this.init();
    }

    private void init() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add((Component)this.toolbar, "North");
        this.panel.setPreferredSize(new Dimension(190, 180));
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.longMoves = AppPrefs.getProperty("longMoves", true);
        this.sameMoves = AppPrefs.getProperty("sameMoves", true);
        this.showLongMovesAction = new ShowLongMovesAction(this);
        this.toolbar.add(AvailableMoves.getToggleButton(this.showLongMovesAction));
        this.toolbar.add(Box.createHorizontalStrut(3));
        this.showSameMovesAction = new ShowSameMovesAction(this);
        this.toolbar.add(AvailableMoves.getToggleButton(this.showSameMovesAction));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.prepareData();
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(final MouseEvent mouseEvent) {
                if (AvailableMoves.this.list.getSelectedIndex() != -1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Move move = ((MoveItem)AvailableMoves.this.model.get(AvailableMoves.this.list.getSelectedIndex())).getMove();
                    if (mouseEvent.getClickCount() >= 2) {
                        AvailableMoves.doMove(move);
                        mouseEvent.consume();
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            new ContextMenu().show(AvailableMoves.this.list, mouseEvent.getX(), mouseEvent.getY());
                        }
                    });
                    mouseEvent.consume();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (AvailableMoves.this.list.getSelectedIndex() != -1 && !listSelectionEvent.getValueIsAdjusting()) {
                    Move move = ((MoveItem)AvailableMoves.this.model.get(AvailableMoves.this.list.getSelectedIndex())).getMove();
                    new DoMoveAction(move).selectPiece();
                }
            }
        });
        this.list.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (AvailableMoves.this.list.getSelectedIndex() != -1 && keyEvent.getKeyCode() == 10) {
                    Move move = ((MoveItem)AvailableMoves.this.model.get(AvailableMoves.this.list.getSelectedIndex())).getMove();
                    AvailableMoves.doMove(move);
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.list);
        this.list.setFont(new Font("Monospaced", 1, 12));
        this.panel.add((Component)jScrollPane, "Center");
    }

    @Override
    public final JComponent getComponent() {
        return this.panel;
    }

    @Override
    public final String getCode() {
        return CODE;
    }

    @Override
    public final void boardContentChanged(List<Integer> list) {
        this.update();
    }

    @Override
    public final void boardChanged() {
        this.update();
    }

    private void update() {
        if (!this.boardManager.isMoving()) {
            this.prepareData();
        }
    }

    private static String matchSpaces(int n, int n2) {
        String string = String.valueOf(n2);
        StringBuilder stringBuilder = new StringBuilder((n -= string.length()) + 3);
        if (n2 < 10) {
            stringBuilder.append("  ");
        } else {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        stringBuilder.append("  ");
        return stringBuilder.toString();
    }

    @Override
    public final void onToolInit(JInternalFrame jInternalFrame) {
    }

    @Override
    public final void onToolStart() {
        this.boardManager.addBoardChangeListener(this);
        this.game.addGameStatusListener(this);
    }

    @Override
    public final void onToolDestroy() {
        this.boardManager.removeBoardListener(this);
        this.game.removeGameStatusListener(this);
        ShowAvailableMovesAction.getInstance().setSelected(false);
        if (this.model != null) {
            this.model.clear();
        }
    }

    private static void doMove(Move move) {
        new DoMoveAction(move).actionPerformed(null);
    }

    @Override
    public final void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public final String getTitle() {
        return Lng.getLabel("AvailableMoves");
    }

    private void prepareData() {
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = this.boardManager.generateMoves(linkedList);
        int n = 1;
        this.model = new DefaultListModel();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        GameStyle gameStyle = this.game.getManager().getCurrentGameStyle();
        for (Move move : linkedList) {
            if (!this.sameMoves) {
                int n5 = move.getFirstPosition();
                int n6 = move.getLastPosition();
                int n7 = move.size();
                if (n5 == n2 && n6 == n3 && n7 == n4) continue;
                this.model.addElement(new MoveItem(gameStyle, move, n++, bl));
                n2 = n5;
                n3 = n6;
                n4 = n7;
                continue;
            }
            this.model.addElement(new MoveItem(gameStyle, move, n++, bl));
        }
        this.list.setModel(this.model);
    }

    public final void showLongMoves(boolean bl) {
        if (this.longMoves != bl) {
            this.longMoves = bl;
            this.update();
        }
    }

    public final void showSameMoves(boolean bl) {
        if (this.sameMoves != bl) {
            this.sameMoves = bl;
            this.update();
        }
    }

    private static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction) {
        return DamaqUI.getToggleButton(selectableCoreAction, DamaqUI.getButtonDimension());
    }

    @Override
    public final void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
        this.update();
    }

    @Override
    public final void playerChanged(GameStatusEvent gameStatusEvent) {
    }

    @Override
    public final Icon getIcon() {
        return (Icon)ShowAvailableMovesAction.getInstance().getValue("SmallIcon");
    }

    @Override
    public void setToolbarVisible(boolean bl) {
        this.toolbar.setVisible(bl);
    }

    private final class ContextMenu
    extends JPopupMenu {
        public ContextMenu() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, AvailableMoves.this.showLongMovesAction);
            this.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, AvailableMoves.this.showSameMovesAction);
            this.add(jCheckBoxMenuItem);
        }
    }

    private final class MoveItem {
        private final Move move;
        private final String stringValue;

        public MoveItem(GameStyle gameStyle, Move move, int n, boolean bl) {
            this.move = move;
            this.stringValue = AvailableMoves.matchSpaces(2, n) + " " + gameStyle.toString(move, AvailableMoves.this.longMoves, bl);
        }

        public final String toString() {
            return this.stringValue;
        }

        public final Move getMove() {
            return this.move;
        }
    }
}

