/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.boardtools.timer;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.damaq.core.Lng;
import net.damaq.core.actions.ShowTimerAction;
import net.damaq.core.boardtools.AbstractBoardTool;
import net.damaq.core.boardtools.timer.ResetTimerAction;
import net.damaq.core.boardtools.timer.SetTimerAction;
import net.damaq.core.boardtools.timer.StartTimerAction;
import net.damaq.core.boardtools.timer.StopTimerAction;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.DamaqUI;
import net.damaq.gui.ToolbarSeparator;

public final class TimeInfo
extends AbstractBoardTool
implements ChangeListener {
    public static final String CODE = TimeInfo.class.getSimpleName();
    private final JPanel panel = new JPanel(new BorderLayout());
    private TimeManager timerManager;
    private JLabel labelWhiteClock = new JLabel("");
    private JLabel labelWhiteTotalClock = new JLabel("");
    private JLabel labelBlackClock = new JLabel("");
    private JLabel labelBlackTotalClock = new JLabel("");
    private Font labelFont = this.labelWhiteClock.getFont().deriveFont(1, 15.0f);
    private JToolBar toolbar;

    public TimeInfo(Game game) {
        this.timerManager = game.getTimerManager();
        this.init();
    }

    private void init() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add((Component)this.toolbar, "North");
        this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(TimeInfo.getButton(StartTimerAction.getInstance()));
        this.toolbar.add(TimeInfo.getButton(StopTimerAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(TimeInfo.getButton(ResetTimerAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(TimeInfo.getButton(SetTimerAction.getInstance()));
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -1.0}, new double[]{-1.0, -1.0});
        tableLayout.setHGap(4);
        tableLayout.setVGap(1);
        JPanel jPanel = new JPanel(tableLayout);
        this.updateValues(this.timerManager.getTime());
        jPanel.add((Component)this.getInfoPanel(this.labelWhiteTotalClock), new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)this.getInfoPanel(this.labelBlackTotalClock), new CustomLayoutConstraints(1, 0));
        jPanel.add((Component)this.getInfoPanel(this.labelWhiteClock), new CustomLayoutConstraints(0, 1));
        jPanel.add((Component)this.getInfoPanel(this.labelBlackClock), new CustomLayoutConstraints(1, 1));
        this.panel.add((Component)jPanel, "Center");
        this.labelWhiteClock.setToolTipText(Lng.getLabel("timer.clockWhite"));
        this.labelWhiteTotalClock.setToolTipText(Lng.getLabel("timer.clockTWhite"));
        this.labelBlackClock.setToolTipText(Lng.getLabel("timer.clockBlack"));
        this.labelBlackTotalClock.setToolTipText(Lng.getLabel("timer.clockTBlack"));
    }

    private static AbstractButton getButton(Action action) {
        return DamaqUI.getButton(action, DamaqUI.getButtonDimension());
    }

    public final JComponent getComponent() {
        return this.panel;
    }

    public final String getCode() {
        return CODE;
    }

    public final void onToolInit(JInternalFrame jInternalFrame) {
    }

    public final void onToolStart() {
        this.timerManager.addChangeListener(this);
    }

    public final void onToolDestroy() {
        this.timerManager.removeChangeListener(this);
        ShowTimerAction showTimerAction = ShowTimerAction.getInstance();
        if (showTimerAction.isSelected()) {
            showTimerAction.actionPerformed(null);
        }
        this.timerManager = null;
    }

    public final String getTitle() {
        return Lng.getLabel("timer");
    }

    public final Icon getIcon() {
        return (Icon)ShowTimerAction.getInstance().getValue("SmallIcon");
    }

    private JPanel getInfoPanel(JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setFont(this.labelFont);
        jPanel.add(jLabel);
        return jPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateValues(((TimeManager)changeEvent.getSource()).getTime());
    }

    private void updateValues(TimeManager.TimeValues timeValues) {
        this.labelWhiteClock.setText(this.convert(timeValues.white));
        this.labelBlackClock.setText(this.convert(timeValues.black));
        this.labelWhiteTotalClock.setText(this.convert(timeValues.totalWhite));
        this.labelBlackTotalClock.setText(this.convert(timeValues.totalBlack));
    }

    private String convert(int n) {
        int n2 = n / 3600;
        int n3 = (n -= 3600 * n2) / 60;
        int n4 = n - 60 * n3;
        StringBuilder stringBuilder = new StringBuilder(8);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append(':');
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }

    public void setToolbarVisible(boolean bl) {
        this.toolbar.setVisible(bl);
    }
}

