/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.managers.interfaces.BoardListener;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoardManager {
    private static final Logger logger = Logger.getLogger(BoardManager.class.getName());
    private Board board;
    private final Vector<BoardListener> boardListeners = new Vector(3);
    private List<Move> availableMoves = null;
    private boolean jumps;
    private boolean isMoving = false;
    private int[] counts = null;

    public BoardManager(Board board) {
        this.board = board;
    }

    private void fireChangeEvent(List<Integer> list) {
        BoardListener[] boardListenerArray;
        this.discardAvailableMoves();
        this.discardCounts();
        for (BoardListener boardListener : boardListenerArray = this.boardListeners.toArray(new BoardListener[this.boardListeners.size()])) {
            boardListener.boardContentChanged(list);
        }
    }

    public static BoardManager getInstance() {
        return ManagerDirector.getInstance().getGameStyleManager().getBoardManager();
    }

    public final Board getBoard() {
        return this.board;
    }

    public final void setBoard(Board board) {
        assert (board != null);
        boolean bl = !this.board.equals(board);
        this.board = board;
        if (bl) {
            this.updateBoard();
        }
    }

    public final boolean isSideToMove(Side side) {
        return this.board.isSideToMove(side);
    }

    public final void setStartPosition() {
        this.board.setStartPosition();
        logger.info("Set start position");
        this.updateBoard();
    }

    public final Piece get(int n, int n2) {
        return this.board.get(n, n2);
    }

    public final Piece get(int n) {
        return this.board.get(n);
    }

    public final int getPosition(int n, int n2) {
        return this.board.getPosition(n, n2);
    }

    public final void set(int n, Piece piece) {
        this.board.set(n, piece);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(n);
        this.fireChangeEvent(arrayList);
    }

    public final void setWithUpgrade(int n, Piece piece) {
        this.board.setWithUpgrade(n, piece);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(n);
        this.fireChangeEvent(arrayList);
    }

    public final void set(Map<Integer, Piece> map) {
        for (Integer n : map.keySet()) {
            this.board.set(n, map.get(n));
        }
        ArrayList arrayList = new ArrayList(map.size());
        arrayList.addAll(map.keySet());
        this.fireChangeEvent(arrayList);
    }

    public final void setEmpty() {
        this.board.setEmpty();
        this.updateBoard();
    }

    public final List<Integer> doMove(Move move, boolean bl) {
        List<Integer> list = this.board.doMove(move, bl);
        this.updateBoard();
        return list;
    }

    private void discardAvailableMoves() {
        if (this.availableMoves != null) {
            this.availableMoves.clear();
            this.availableMoves = null;
        }
    }

    private void discardCounts() {
        this.counts = null;
    }

    public final int getMaxBoardLength() {
        return this.board.getMaxBoardLength();
    }

    public final int getBoardWidth() {
        return this.board.getBoardWidth();
    }

    public final boolean generateMoves(List<Move> list) {
        if (this.availableMoves == null) {
            this.availableMoves = new LinkedList<Move>();
            this.jumps = this.board.generateMoves(this.availableMoves);
        }
        list.addAll(this.availableMoves);
        return this.jumps;
    }

    public final int evaluation() {
        return this.board.evaluation();
    }

    public final void addBoardChangeListener(BoardListener boardListener) {
        this.boardListeners.add(boardListener);
    }

    public final void removeBoardListener(BoardListener boardListener) {
        this.boardListeners.remove(boardListener);
    }

    public final boolean isOurs(int n) {
        return this.board.isOurs(n);
    }

    public final boolean isEmpty(int n) {
        return this.get(n) == Piece.NOTHING;
    }

    public final boolean isMoving() {
        return this.isMoving;
    }

    public final void setMoving(boolean bl) {
        boolean bl2 = this.isMoving;
        this.isMoving = bl;
        if (bl2) {
            this.updateBoard();
        }
    }

    private void updateBoard() {
        this.fireChangeEvent(new ArrayList<Integer>(0));
    }

    public final void setSideToMove(Side side) {
        this.board.setSideToMove(side);
        this.discardAvailableMoves();
    }

    public final Side getSideToMove() {
        return this.board.isSideToMove(Side.WHITES) ? Side.WHITES : Side.BLACKS;
    }

    public final boolean canMove() {
        if (this.availableMoves == null) {
            this.availableMoves = new LinkedList<Move>();
            this.jumps = this.board.generateMoves(this.availableMoves);
        }
        return !this.availableMoves.isEmpty();
    }

    public final int[] getCounts() {
        if (this.counts != null) {
            return this.counts;
        }
        this.counts = this.board.getCounts();
        return this.counts;
    }
}

