/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.damaq.core.AppPrefs;
import net.damaq.core.boardtools.BoardTool;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.boardtools.damexchange.ChatWindow;
import net.damaq.core.boardtools.editor.Editor;
import net.damaq.core.boardtools.history.History;
import net.damaq.core.boardtools.moves.AvailableMoves;
import net.damaq.core.boardtools.timer.TimeInfo;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.managers.interfaces.ComponentManager;
import net.damaq.gui.LookAndFeels;
import net.damaq.gui.Skin;
import net.damaq.utilities.Swinger;

public final class DesktopManager
implements ComponentManager,
InternalFrameListener,
ChangeListener {
    private final JDesktopPane pane = new JDesktopPane();
    private final ManagerDirector director;
    private volatile Hashtable<String, BoardTool> tools = new Hashtable(4);

    public DesktopManager(ManagerDirector managerDirector) {
        this.director = managerDirector;
        this.pane.setDragMode(0);
        this.pane.setBorder(new BackgroundPanel());
        this.pane.putClientProperty("substancelaf.watermark.toignore", Boolean.TRUE);
        this.pane.setVisible(true);
        LookAndFeels.getInstance().addChangeListener(this);
    }

    public final Component getManagerComponent() {
        return this.pane;
    }

    private JInternalFrame createInternalFrame(BoardTool boardTool, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        JInternalFrame jInternalFrame = new JInternalFrame(string, bl, bl2, bl3, bl4);
        jInternalFrame.setFrameIcon(boardTool.getIcon());
        jInternalFrame.setName(boardTool.getCode());
        if (bl5) {
            jInternalFrame.setDefaultCloseOperation(1);
        }
        jInternalFrame.addInternalFrameListener(this);
        this.tools.put(boardTool.getCode(), boardTool);
        boardTool.onToolInit(jInternalFrame);
        boardTool.setToolbarVisible(AppPrefs.getProperty("visibleToolbars", true));
        JComponent jComponent = boardTool.getComponent();
        jInternalFrame.getContentPane().add(jComponent);
        return jInternalFrame;
    }

    public final void addDrawBoard() {
        BoardManager boardManager = this.director.getGameStyleManager().getBoardManager();
        DrawBoard drawBoard = new DrawBoard(boardManager);
        JInternalFrame jInternalFrame = this.createInternalFrame(drawBoard, drawBoard.getTitle(), false, false, false, false, false);
        this.initDrawBoardFrame(jInternalFrame);
        jInternalFrame.setFocusable(false);
        jInternalFrame.putClientProperty("substancelaf.watermark.toignore", Boolean.TRUE);
        this.makeVisible(jInternalFrame, DrawBoard.CODE);
    }

    public final void addAvailableMoves() {
        if (this.tools.get(AvailableMoves.CODE) != null) {
            return;
        }
        AvailableMoves availableMoves = new AvailableMoves(this.director.getGame());
        JInternalFrame jInternalFrame = this.createInternalFrame(availableMoves, availableMoves.getTitle(), true, true, false, false, false);
        this.makeVisible(jInternalFrame, AvailableMoves.CODE);
    }

    public final void addHistory() {
        if (this.tools.get(History.CODE) != null) {
            return;
        }
        History history = new History(this.director.getGame());
        JInternalFrame jInternalFrame = this.createInternalFrame(history, history.getTitle(), true, true, false, false, false);
        this.makeVisible(jInternalFrame, History.CODE);
    }

    private void makeVisible(JInternalFrame jInternalFrame, String string) {
        jInternalFrame.pack();
        this.placeToLocation(jInternalFrame, string);
        this.pane.add(jInternalFrame);
        jInternalFrame.setVisible(true);
        jInternalFrame.moveToFront();
    }

    private void placeToLocation(JInternalFrame jInternalFrame, String string) {
        if (AppPrefs.getProperty("position", true)) {
            string = "." + string;
            if (AppPrefs.getProperty("posX" + string, -1) != -1) {
                Dimension dimension = jInternalFrame.getPreferredSize();
                Rectangle rectangle = new Rectangle();
                rectangle.x = AppPrefs.getProperty("posX" + string, jInternalFrame.getX());
                rectangle.y = AppPrefs.getProperty("posY" + string, jInternalFrame.getY());
                if (jInternalFrame.isResizable()) {
                    rectangle.height = AppPrefs.getProperty("posH" + string, dimension.height);
                    rectangle.width = AppPrefs.getProperty("posW" + string, dimension.width);
                    jInternalFrame.setSize(new Dimension(rectangle.width, rectangle.height));
                } else {
                    rectangle.height = dimension.height;
                    rectangle.width = dimension.width;
                }
                if (!this.checkIntersectsActual(rectangle)) {
                    jInternalFrame.setLocation(rectangle.x, rectangle.y);
                    return;
                }
            }
        }
        this.placeFrameAuto(jInternalFrame);
    }

    private boolean checkIntersectsActual(Rectangle rectangle) {
        for (JInternalFrame jInternalFrame : this.pane.getAllFrames()) {
            if (!jInternalFrame.getBounds().intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    private void placeFrameAuto(JInternalFrame jInternalFrame) {
        JInternalFrame[] jInternalFrameArray = this.pane.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            jInternalFrame.setLocation(2, 2);
            return;
        }
        Rectangle rectangle = jInternalFrame.getBounds();
        Rectangle rectangle2 = new Rectangle(this.pane.getSize().width, this.pane.getSize().height);
        for (JInternalFrame jInternalFrame2 : jInternalFrameArray) {
            rectangle.x = jInternalFrame2.getX();
            rectangle.y = jInternalFrame2.getY() + jInternalFrame2.getHeight() + 2;
            boolean bl = DesktopManager.testPlacement(rectangle2, jInternalFrame, jInternalFrameArray, rectangle);
            if (bl) {
                return;
            }
            rectangle.x = jInternalFrame2.getX() + jInternalFrame2.getWidth() + 2;
            rectangle.y = jInternalFrame2.getY();
            bl = DesktopManager.testPlacement(rectangle2, jInternalFrame, jInternalFrameArray, rectangle);
            if (bl) {
                return;
            }
            rectangle.x = jInternalFrame2.getX();
            rectangle.y = jInternalFrame2.getY() - jInternalFrame2.getHeight();
            bl = DesktopManager.testPlacement(rectangle2, jInternalFrame, jInternalFrameArray, rectangle);
            if (bl) {
                return;
            }
            rectangle.x = jInternalFrame2.getX() - jInternalFrame2.getWidth();
            rectangle.y = jInternalFrame2.getY();
            bl = DesktopManager.testPlacement(rectangle2, jInternalFrame, jInternalFrameArray, rectangle);
            if (!bl) continue;
            return;
        }
        Swinger.centerDialog(this.pane, jInternalFrame);
    }

    private static boolean testPlacement(Rectangle rectangle, JInternalFrame jInternalFrame, JInternalFrame[] jInternalFrameArray, Rectangle rectangle2) {
        if (!rectangle.contains(rectangle2)) {
            return false;
        }
        boolean bl = true;
        for (JInternalFrame jInternalFrame2 : jInternalFrameArray) {
            if (!jInternalFrame2.getBounds().intersects(rectangle2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            jInternalFrame.setLocation(rectangle2.x, rectangle2.y);
            return true;
        }
        return false;
    }

    public final void removeAvailableMoves() {
        this.closeTool(AvailableMoves.CODE);
    }

    public final void addEditor() {
        if (this.tools.get(Editor.CODE) != null) {
            return;
        }
        Editor editor = new Editor();
        JInternalFrame jInternalFrame = this.createInternalFrame(editor, editor.getTitle(), true, true, false, false, false);
        this.makeVisible(jInternalFrame, Editor.CODE);
    }

    private JInternalFrame closeTool(String string) {
        JInternalFrame jInternalFrame = this.getInternalFrameByCode(string);
        if (jInternalFrame != null) {
            jInternalFrame.doDefaultCloseAction();
        }
        return jInternalFrame;
    }

    private void removeTool(String string) {
        BoardTool boardTool = this.tools.get(string);
        if (boardTool != null) {
            this.tools.remove(string);
            boardTool.onToolDestroy();
        }
    }

    private JInternalFrame getInternalFrameByCode(String string) {
        JInternalFrame[] jInternalFrameArray;
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.pane.getAllFrames()) {
            if (!jInternalFrame.getName().equals(string)) continue;
            return jInternalFrame;
        }
        return null;
    }

    public final void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        this.tools.get(internalFrameEvent.getInternalFrame().getName()).onToolStart();
    }

    public final void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        String string = jInternalFrame.getName();
        BoardTool boardTool = this.tools.get(string);
        if (boardTool != null) {
            boardTool.onToolClosing();
        }
    }

    public final void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        String string = jInternalFrame.getName();
        this.disposeTool(jInternalFrame, string);
    }

    private void disposeTool(JInternalFrame jInternalFrame, String string) {
        DesktopManager.storeWindowPosition(jInternalFrame, string);
        this.removeTool(string);
    }

    public final void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public final void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public final void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public final void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public final BoardTool getTool(String string) {
        return this.tools.get(string);
    }

    public final void removeEditor() {
        this.closeTool(Editor.CODE);
    }

    public final void closeAll() {
        for (JInternalFrame jInternalFrame : this.pane.getAllFrames()) {
            jInternalFrame.doDefaultCloseAction();
        }
    }

    public final void removeHistory() {
        this.closeTool(History.CODE);
    }

    public void addTimer() {
        if (this.tools.get(TimeInfo.CODE) != null) {
            return;
        }
        TimeInfo timeInfo = new TimeInfo(this.director.getGame());
        JInternalFrame jInternalFrame = this.createInternalFrame(timeInfo, timeInfo.getTitle(), true, true, false, false, false);
        this.makeVisible(jInternalFrame, TimeInfo.CODE);
    }

    public void removeTimer() {
        this.closeTool(TimeInfo.CODE);
    }

    public void lookAndFeelChanged() {
        JInternalFrame jInternalFrame = this.getInternalFrameByCode(DrawBoard.CODE);
        if (jInternalFrame != null) {
            this.initDrawBoardFrame(jInternalFrame);
        }
    }

    private void initDrawBoardFrame(JInternalFrame jInternalFrame) {
        jInternalFrame.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        jInternalFrame.setBackground(null);
        jInternalFrame.setOpaque(true);
        jInternalFrame.setBorder(null);
        ((BasicInternalFrameUI)jInternalFrame.getUI()).setNorthPane(null);
    }

    public void updateToolbars(boolean bl) {
        for (BoardTool boardTool : this.tools.values()) {
            boardTool.setToolbarVisible(bl);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.pane.revalidate();
        this.pane.repaint();
    }

    public JInternalFrame addChatWindow() {
        if (this.tools.get(ChatWindow.CODE) != null) {
            return null;
        }
        ChatWindow chatWindow = new ChatWindow(this.director.getGame());
        JInternalFrame jInternalFrame = this.createInternalFrame(chatWindow, chatWindow.getTitle(), true, true, false, false, true);
        this.makeVisible(jInternalFrame, ChatWindow.CODE);
        return jInternalFrame;
    }

    public void removeChatWindow() {
        JInternalFrame jInternalFrame = this.closeTool(ChatWindow.CODE);
        if (jInternalFrame != null && jInternalFrame.getDefaultCloseOperation() == 1) {
            this.disposeTool(jInternalFrame, jInternalFrame.getName());
            jInternalFrame.dispose();
        }
    }

    private static void storeWindowPosition(JInternalFrame jInternalFrame, String string) {
        string = "." + string;
        if (AppPrefs.getProperty("position", true)) {
            AppPrefs.storeProperty("posH" + string, jInternalFrame.getHeight());
            AppPrefs.storeProperty("posW" + string, jInternalFrame.getWidth());
            AppPrefs.storeProperty("posX" + string, jInternalFrame.getX());
            AppPrefs.storeProperty("posY" + string, jInternalFrame.getY());
        } else {
            AppPrefs.removeProperty("posH" + string);
            AppPrefs.removeProperty("posW" + string);
            AppPrefs.removeProperty("posX" + string);
            AppPrefs.removeProperty("posY" + string);
        }
    }

    private static final class BackgroundPanel
    implements Border {
        private float alignmentX = 0.5f;
        private float alignmentY = 0.5f;

        public final void setImageAlignmentX(float f) {
            this.alignmentX = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        }

        public final void setImageAlignmentY(float f) {
            this.alignmentY = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        }

        public final Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        public final boolean isBorderOpaque() {
            return true;
        }

        public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Skin skin = LookAndFeels.getInstance().getActiveSkin();
            Image image = skin.getBackgroundImage();
            if (image != null) {
                if (skin.isBackgroundTiled()) {
                    this.drawTiled(image, graphics, n3, n4);
                } else if (skin.isBackgroundStretched()) {
                    graphics.drawImage(image, 0, 0, n3, n4, skin.getBackgroundColor(), null);
                } else {
                    this.drawActual(image, graphics, n3, n4);
                }
            } else {
                graphics.setColor(skin.getBackgroundColor());
                graphics.fillRect(0, 0, n3, n4);
            }
        }

        private void drawTiled(Image image, Graphics graphics, int n, int n2) {
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            for (int i = 0; i < n; i += n3) {
                for (int j = 0; j < n2; j += n4) {
                    graphics.drawImage(image, i, j, null, null);
                }
            }
        }

        private void drawActual(Image image, Graphics graphics, int n, int n2) {
            float f = (float)(n - image.getWidth(null)) * this.alignmentX;
            float f2 = (float)(n2 - image.getHeight(null)) * this.alignmentY;
            graphics.drawImage(image, (int)f, (int)f2, null);
        }
    }
}

