/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.EditorModeAction;
import net.damaq.core.actions.EventType;
import net.damaq.core.actions.PlayerToMoveAction;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.GameInfoManager;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.GameStyleManager;
import net.damaq.core.managers.HistoryManager;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.core.managers.player.ComputerPlayer;
import net.damaq.core.managers.player.HumanPlayer;
import net.damaq.core.managers.player.Player;
import net.damaq.core.managers.player.PlayerTask;
import net.damaq.dialogs.GameDetails;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.pdn.GameStatus;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class Game
extends Thread {
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    private GameStatus gameStatus;
    private volatile Player[] players = new Player[2];
    private final GameStyleManager manager;
    private final HistoryManager historyManager;
    private final GameInfoManager gameInfoManager;
    private final TimeManager timerManager;
    private volatile BlockingQueue<BoardAction> queue;
    private boolean threadSuspended = false;
    private PlayerTask playerTask;
    private final EventListenerList listenerList = new EventListenerList();
    private static final int FIRST = 0;
    private static final int SECOND = 1;
    private volatile int activePlayer = 0;
    private boolean editorMode = false;
    private Side movingSide;

    public Game(GameStyleManager gameStyleManager) {
        this.manager = gameStyleManager;
        this.historyManager = new HistoryManager(this);
        this.gameInfoManager = new GameInfoManager(this);
        this.timerManager = new TimeManager(this);
        this.queue = new ArrayBlockingQueue<BoardAction>(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        while (!this.isInterrupted()) {
            Object object;
            boolean bl;
            while (!this.queue.isEmpty()) {
                BoardAction boardAction = (BoardAction)this.queue.peek();
                try {
                    if (this.isEditorMode() && boardAction.getEventType() != EventType.EDITOR && boardAction.getEventType() != EventType.SETTINGS && boardAction.getEventType() != EventType.PASTE_FEN) {
                        EditorModeAction.getInstance().doAction();
                    }
                    logger.info("action started");
                    boardAction.doAction();
                    logger.info("action removed");
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                }
                finally {
                    this.queue.remove(boardAction);
                }
            }
            this.updateActivePlayer();
            boolean bl2 = this.canMove();
            boolean bl3 = bl = !bl2 || this.getManager().getCurrentGameStyle().isDraw(this.historyManager.getMoveList());
            if (!this.isEditorMode() && bl && this.gameStatus == GameStatus.UNDECIDED) {
                this.setEndOfGame(bl2);
            }
            Player player = this.getActivePlayer();
            if (bl2 && !this.isEditorMode()) {
                try {
                    this.playerTask = player.getTask();
                    String string = player.isHuman() ? "human goes to play" : "computer goes to play";
                    logger.info(string);
                    object = executorService.submit(new FutureTask(this.playerTask));
                    object.get();
                    String string2 = player.isHuman() ? "human stops to play" : "computer stops to play";
                    logger.info(string2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    LogUtils.processException(logger, interruptedException);
                    continue;
                }
                catch (CancellationException cancellationException) {
                    LogUtils.processException(logger, cancellationException);
                    continue;
                }
                catch (ExecutionException executionException) {
                    LogUtils.processException(logger, executionException);
                    continue;
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                    continue;
                }
                finally {
                    this.playerTask = null;
                    continue;
                }
            }
            object = this;
            synchronized (object) {
                this.threadSuspended = true;
                while (this.threadSuspended) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        LogUtils.processException(logger, interruptedException);
                    }
                }
                logger.info("Thread woke up");
            }
        }
        executorService.shutdown();
    }

    private void setEndOfGame(boolean bl) {
        String string;
        String string2;
        if (!bl) {
            if (this.movingSide == Side.WHITES) {
                this.gameStatus = GameStatus.BLACK_WINS;
                if (this.getOppositePlayer().isHuman()) {
                    string2 = Lng.getLabel("message.info.playerBlacksWin");
                    string = "h_winner.wav";
                } else {
                    string2 = Lng.getLabel("message.info.compBlacksWin");
                    string = "c_winner.wav";
                }
            } else {
                this.gameStatus = GameStatus.WHITE_WINS;
                if (this.getOppositePlayer().isHuman()) {
                    string2 = Lng.getLabel("message.info.playerWhitesWin");
                    string = "h_winner.wav";
                } else {
                    string2 = Lng.getLabel("message.info.compWhitesWin");
                    string = "c_winner.wav";
                }
            }
        } else {
            this.gameStatus = GameStatus.DRAW;
            string2 = Lng.getLabel("message.info.draw");
            string = "draw.wav";
        }
        this.historyManager.setGameStatus(this.gameStatus);
        try {
            this.showGameEnd(string2, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogUtils.processException(logger, invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            LogUtils.processException(logger, interruptedException);
        }
        if (bl && !this.getActivePlayer().isHuman()) {
            PlayerToMoveAction.getInstance().doAction();
        }
    }

    public final Player getActivePlayer() {
        return this.players[this.activePlayer];
    }

    public final Player getOppositePlayer() {
        return this.players[this.activePlayer ^ 1];
    }

    public final void updateActivePlayer() {
        BoardManager boardManager = this.manager.getBoardManager();
        if (!boardManager.isSideToMove(this.movingSide)) {
            this.activePlayer ^= 1;
            this.movingSide = Side.getOppositeSide(this.movingSide);
            this.firePlayerChangedEvent();
            this.fireSideChangeEvent();
        }
    }

    public final void playersSwitched() {
        this.firePlayerChangedEvent();
    }

    public final GameStyleManager getManager() {
        return this.manager;
    }

    private synchronized void continueThread() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Continue the Game Thread");
        }
        this.threadSuspended = false;
        this.notify();
    }

    public final void offerTask(BoardAction boardAction) {
        if (boardAction.isUnique()) {
            EventType eventType = boardAction.getEventType();
            for (BoardAction boardAction2 : this.queue) {
                if (!boardAction2.getEventType().equals((Object)eventType)) continue;
                return;
            }
        }
        this.queue.offer(boardAction);
        logger.info("action queued");
        if (this.playerTask != null) {
            this.playerTask.cancelMove();
        }
        if (this.threadSuspended) {
            this.continueThread();
        }
    }

    public final Player[] getActivePlayers() {
        return this.players;
    }

    public final void setOppositePlayer(boolean bl) {
        this.players[this.activePlayer ^ 1] = this.getPlayer(bl);
        this.firePlayerChangedEvent();
    }

    public final void init() {
        this.movingSide = Side.WHITES;
        this.resetGameStatus();
        this.activePlayer = 0;
        this.players[0] = this.getPlayer(true);
        this.players[1] = this.getPlayer(false);
        this.firePlayerChangedEvent();
        this.gameInfoManager.init(this);
        this.historyManager.init();
        this.timerManager.init();
        this.fireSideChangeEvent();
    }

    public final void loadGame(GameDetails gameDetails) {
        if (this.playerTask != null) {
            this.playerTask.cancelMove();
        }
        if (this.threadSuspended) {
            this.continueThread();
        }
        this.getManager().setStyle(gameDetails.getSupportedGameStyle());
        BoardManager boardManager = this.getManager().getBoardManager();
        this.historyManager.setLoadedHistory(gameDetails);
        this.timerManager.init();
        this.movingSide = boardManager.getSideToMove();
        this.gameStatus = gameDetails.getPdnGame().getResultSection().getResult();
        this.historyManager.setGameStatus(this.gameStatus);
        this.activePlayer = 0;
        this.players[0] = this.getPlayer(true);
        this.players[1] = this.getPlayer(true);
        this.firePlayerChangedEvent();
        this.gameInfoManager.setPdnGame(gameDetails.getPdnGame());
        this.fireSideChangeEvent();
    }

    public final void setActivePlayer(boolean bl) {
        this.players[this.activePlayer] = this.getPlayer(bl);
        this.firePlayerChangedEvent();
    }

    private Player getPlayer(boolean bl) {
        return bl ? new HumanPlayer(this) : new ComputerPlayer(this);
    }

    public final boolean isEditorMode() {
        return this.editorMode;
    }

    public final void setEditorMode(boolean bl) {
        this.editorMode = bl;
    }

    public final void setSideToMove(Side side) {
        this.manager.getBoardManager().setSideToMove(side);
        this.movingSide = side;
        this.fireSideChangeEvent();
    }

    private boolean canMove() {
        BoardManager boardManager = this.getManager().getBoardManager();
        return boardManager.isSideToMove(this.movingSide) && boardManager.canMove();
    }

    public final void addGameStatusListener(GameStatusListener gameStatusListener) {
        this.listenerList.add(GameStatusListener.class, gameStatusListener);
    }

    public final void removeGameStatusListener(GameStatusListener gameStatusListener) {
        this.listenerList.remove(GameStatusListener.class, gameStatusListener);
    }

    public final HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public final void resetGameStatus() {
        this.gameStatus = GameStatus.UNDECIDED;
    }

    private void showGameEnd(final String string, String string2) throws InvocationTargetException, InterruptedException {
        Swinger.playSound(Swinger.getCachedAudioClip(string2));
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                Swinger.showInformationDialog(MainApp.getInstance().getMainAppFrame(), string);
            }
        });
    }

    private void fireSideChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        GameStatusEvent gameStatusEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GameStatusListener.class) continue;
            if (gameStatusEvent == null) {
                gameStatusEvent = new GameStatusEvent(this, this.movingSide, this.players[this.activePlayer], this.players[this.activePlayer ^ 1]);
            }
            ((GameStatusListener)objectArray[i + 1]).sideToMoveChanged(gameStatusEvent);
        }
    }

    private void firePlayerChangedEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        GameStatusEvent gameStatusEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GameStatusListener.class) continue;
            if (gameStatusEvent == null) {
                gameStatusEvent = new GameStatusEvent(this, this.movingSide, this.players[this.activePlayer], this.players[this.activePlayer ^ 1]);
            }
            ((GameStatusListener)objectArray[i + 1]).playerChanged(gameStatusEvent);
        }
    }

    public final void doMove(DrawBoard drawBoard, Move move, boolean bl) {
        List<Integer> list = drawBoard.doMove(move, bl);
        this.historyManager.addMove(move, list);
    }

    public final GameInfoManager getGameInfoManager() {
        return this.gameInfoManager;
    }

    public final Side getPlayerSide(Player player) {
        if (this.movingSide == Side.WHITES) {
            if (this.getActivePlayer().equals(player)) {
                return Side.WHITES;
            }
            if (this.getOppositePlayer().equals(player)) {
                return Side.BLACKS;
            }
        } else {
            if (this.getActivePlayer().equals(player)) {
                return Side.BLACKS;
            }
            if (this.getOppositePlayer().equals(player)) {
                return Side.WHITES;
            }
        }
        return null;
    }

    public final GameStatus getGameStatus() {
        return this.gameStatus;
    }

    public TimeManager getTimerManager() {
        return this.timerManager;
    }
}

