/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.gamestyle.Side;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNResultSection;

public final class GameInfoManager
implements GameStatusListener {
    private PDNGame pdnGame;
    private final EventListenerList listenerList = new EventListenerList();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
    private final Game game;

    public GameInfoManager(Game game) {
        this.game = game;
        this.pdnGame = new PDNGame();
        game.addGameStatusListener(this);
    }

    public final void init(Game game) {
        this.pdnGame = new PDNGame();
        this.pdnGame.addSection("DATE", dateFormat.format(Calendar.getInstance().getTime()));
        this.initData(game);
        this.fireChangeEvent();
    }

    private void initData(Game game) {
        this.setCompOn(game);
        this.fireChangeEvent();
    }

    private void setCompOn(Game game) {
        boolean bl = game.getActivePlayer().isHuman();
        boolean bl2 = game.getOppositePlayer().isHuman();
        if (!bl) {
            if (game.getActivePlayer().getSide() == Side.WHITES) {
                if (this.pdnGame.getWhiteSection() == null) {
                    this.pdnGame.addSection("WHITE", "Damaq 1.01");
                }
            } else if (this.pdnGame.getBlackSection() == null) {
                this.pdnGame.addSection("BLACK", "Damaq 1.01");
            }
        }
        if (!bl2) {
            if (game.getOppositePlayer().getSide() == Side.WHITES) {
                if (this.pdnGame.getWhiteSection() == null) {
                    this.pdnGame.addSection("WHITE", "Damaq 1.01");
                }
            } else if (this.pdnGame.getBlackSection() == null) {
                this.pdnGame.addSection("BLACK", "Damaq 1.01");
            }
        }
    }

    private void updatePlayers(Game game) {
        boolean bl = game.getActivePlayer().isHuman();
        boolean bl2 = game.getOppositePlayer().isHuman();
        this.setCompOn(game);
        if (bl) {
            if (game.getActivePlayer().getSide() == Side.WHITES) {
                if (this.pdnGame.getWhiteSection() != null && this.pdnGame.getWhiteSection().getStringValue().equals("Damaq 1.01") && this.pdnGame.getBlackSection() != null) {
                    this.pdnGame.addSection("WHITE", this.pdnGame.getBlackSection().getStringValue());
                }
            } else if (this.pdnGame.getBlackSection() != null && this.pdnGame.getBlackSection().getStringValue().equals("Damaq 1.01") && this.pdnGame.getWhiteSection() != null) {
                this.pdnGame.addSection("BLACK", this.pdnGame.getWhiteSection().getStringValue());
            }
        }
        if (bl2) {
            if (game.getOppositePlayer().getSide() == Side.WHITES) {
                if (this.pdnGame.getWhiteSection() != null && this.pdnGame.getWhiteSection().getStringValue().equals("Damaq 1.01") && this.pdnGame.getBlackSection() != null) {
                    this.pdnGame.addSection("WHITE", this.pdnGame.getBlackSection().getStringValue());
                }
            } else if (this.pdnGame.getBlackSection() != null && this.pdnGame.getBlackSection().getStringValue().equals("Damaq 1.01") && this.pdnGame.getWhiteSection() != null) {
                this.pdnGame.addSection("BLACK", this.pdnGame.getWhiteSection().getStringValue());
            }
        }
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public final PDNGame getPdnGame() {
        if (this.pdnGame.getResultSection() == null) {
            this.pdnGame.setResultSection(new PDNResultSection(this.game.getGameStatus()));
        }
        return this.pdnGame;
    }

    public final void setPdnGame(PDNGame pDNGame) {
        this.pdnGame = pDNGame;
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public final void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
    }

    public final void playerChanged(GameStatusEvent gameStatusEvent) {
        this.updatePlayers((Game)gameStatusEvent.getSource());
        this.fireChangeEvent();
    }
}

