/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.util.List;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HistoryItem {
    public static final int WHITE_COUNTS = 0;
    public static final int BLACK_COUNTS = 1;
    private Move move = null;
    private boolean jumps = false;
    private final Board board;
    private int[] counts = null;
    private List<Integer> jumpedPieces = null;
    private String comment = null;
    private Type type;

    public HistoryItem() {
        this.board = null;
        this.counts = null;
        this.type = Type.FIRST_NULL;
    }

    public HistoryItem(Board board, int[] nArray) {
        this.board = board;
        this.counts = nArray;
        this.type = Type.PROGRESS;
    }

    public HistoryItem(Board board) {
        this.board = board;
        this.type = Type.PROGRESS;
    }

    public final boolean isFirstEmpty() {
        return this.type == Type.FIRST_NULL;
    }

    public final Move getMove() {
        return this.move;
    }

    public final boolean isJumps() {
        return this.jumps;
    }

    public final Board getBoard() {
        return this.board.doCopy();
    }

    public final List<Integer> getJumpedPieces() {
        return this.jumpedPieces;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String string) {
        this.comment = string;
    }

    public final void setMove(Move move, List<Integer> list) {
        assert (this.board != null);
        if (this.type == Type.FIRST_NULL) {
            throw new IllegalStateException("State must be in progress or finished. Board cannot be null.");
        }
        this.move = move;
        this.jumps = list != null && !list.isEmpty();
        this.jumpedPieces = list;
        this.type = Type.MOVE;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final boolean isEnd() {
        return this.type == Type.PROGRESS || this.type == Type.BLACKS_WIN || this.type == Type.DRAW || this.type == Type.WHITES_WIN;
    }

    public final boolean isMove() {
        return this.type == Type.MOVE;
    }

    public final boolean isMoveBack() {
        return this.type == Type.MOVE_BACK;
    }

    public final int[] getCounts() {
        if (this.board == null) {
            throw new IllegalStateException("Board cannot be null");
        }
        if (this.counts == null) {
            this.counts = this.board.getCounts();
        }
        return this.counts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FIRST_NULL,
        MOVE,
        MOVE_BACK,
        PROGRESS,
        BLACKS_WIN,
        WHITES_WIN,
        DRAW;

    }
}

