/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.HistoryEvent;
import net.damaq.core.managers.HistoryItem;
import net.damaq.core.managers.interfaces.BoardListener;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.core.managers.interfaces.HistoryListener;
import net.damaq.dialogs.GameDetails;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.pdn.GameStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HistoryManager
implements BoardListener,
GameStatusListener {
    private static final Logger logger = Logger.getLogger(HistoryManager.class.getName());
    private final EventListenerList listenerList = new EventListenerList();
    private final Vector<HistoryItem> moves = new Vector();
    private int backMoves;
    private final BoardManager boardManager;
    private final Game game;
    private boolean modified = false;

    public HistoryManager(Game game) {
        this.game = game;
        this.boardManager = game.getManager().getBoardManager();
        game.addGameStatusListener(this);
        this.boardManager.addBoardChangeListener(this);
    }

    public final void addMove(Move move, List<Integer> list) {
        this.setModified();
        int n = this.getPlayingIndex();
        HistoryItem historyItem = this.moves.get(n);
        if (this.backMoves > 0) {
            if (historyItem.getMove().equals(move)) {
                --this.backMoves;
                historyItem.setType(HistoryItem.Type.MOVE);
                this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n, false);
            } else {
                this.backMoves = 0;
                historyItem.setMove(move, list);
                this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n, true);
                this.trimDataFromEnd(n + 1);
                this.addProgressItem();
            }
        } else {
            historyItem.setMove(move, list);
            this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n, true);
            this.addProgressItem();
        }
    }

    private synchronized void revertTo(HistoryItem historyItem) {
        this.backMoves = this.moves.lastIndexOf(historyItem);
    }

    public final synchronized void undo() {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.setModified();
        this.revertTo(this.moves.get(this.moves.size() - 1));
    }

    public final synchronized HistoryItem getLastItem() {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.setModified();
        return this.moves.get(this.moves.size() - 1);
    }

    public final synchronized boolean canUndo() {
        int n = this.getPlayingIndex() - 1;
        return n >= 0 && this.canUndoTo(n);
    }

    private boolean canUndoTo(int n) {
        return this.moves.size() > 1 && this.moves.get(n).getType() == HistoryItem.Type.MOVE;
    }

    private boolean canRedoTo(int n) {
        if (this.backMoves <= 0 || this.moves.size() < 0 || n >= this.moves.size()) {
            return false;
        }
        HistoryItem historyItem = this.moves.get(n);
        return historyItem.getType() == HistoryItem.Type.MOVE_BACK || historyItem.isEnd();
    }

    public final synchronized boolean canRedo() {
        return this.backMoves > 0;
    }

    @Override
    public final synchronized void boardContentChanged(List<Integer> list) {
        if (this.game.isEditorMode()) {
            this.setModified();
            this.boardChanged();
        }
    }

    @Override
    public final synchronized void boardChanged() {
        if (this.game.isEditorMode()) {
            this.setModified();
            this.clearData();
        }
    }

    private void clearData() {
        this.game.resetGameStatus();
        int n = this.moves.size();
        this.moves.clear();
        this.backMoves = 0;
        if (n > 0) {
            this.fireHistoryEvent(HistoryEvent.HistoryEventType.REMOVEALL, 0, n - 1, true);
        }
        if (this.boardManager.isSideToMove(Side.BLACKS)) {
            this.addNullMove();
        }
        this.addProgressItem();
    }

    private void trimDataFromEnd(int n) {
        int n2;
        this.game.resetGameStatus();
        for (int i = n2 = this.moves.size() - 1; i >= n; --i) {
            this.moves.remove(i);
        }
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.REMOVE, n, n2, true);
    }

    private void addProgressItem() {
        this.moves.add(new HistoryItem(this.boardManager.getBoard().doCopy(), this.boardManager.getCounts()));
        int n = this.moves.size() - 1;
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.ADD, n, n, false);
    }

    private void addNullMove() {
        this.moves.add(new HistoryItem());
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.ADD, 0, 0, true);
    }

    private void fireHistoryEvent(HistoryEvent.HistoryEventType historyEventType, int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        HistoryEvent historyEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HistoryListener.class) continue;
            if (historyEvent == null) {
                historyEvent = new HistoryEvent(this, historyEventType, n, n2, bl);
            }
            ((HistoryListener)objectArray[i + 1]).historyFlowChanged(historyEvent);
        }
    }

    public final Iterator<HistoryItem> iterator() {
        return this.moves.iterator();
    }

    public final synchronized int getSize() {
        return this.moves.size();
    }

    public final void addHistoryListener(HistoryListener historyListener) {
        this.listenerList.add(HistoryListener.class, historyListener);
    }

    public final void removeHistoryListener(HistoryListener historyListener) {
        this.listenerList.remove(HistoryListener.class, historyListener);
    }

    public final synchronized HistoryItem getItem(int n) {
        assert (n < this.moves.size());
        return this.moves.get(n);
    }

    @Override
    public final void playerChanged(GameStatusEvent gameStatusEvent) {
    }

    public final synchronized void init() {
        this.clearData();
    }

    public final synchronized void setGameStatus(GameStatus gameStatus) {
        HistoryItem.Type type;
        assert (!this.moves.isEmpty());
        int n = this.moves.size() - 1;
        HistoryItem historyItem = this.moves.get(n);
        switch (gameStatus) {
            case BLACK_WINS: {
                type = HistoryItem.Type.BLACKS_WIN;
                break;
            }
            case WHITE_WINS: {
                type = HistoryItem.Type.WHITES_WIN;
                break;
            }
            case DRAW: {
                type = HistoryItem.Type.DRAW;
                break;
            }
            default: {
                type = HistoryItem.Type.PROGRESS;
            }
        }
        historyItem.setType(type);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n, false);
    }

    public final synchronized int getLastActiveIndex() {
        return this.getPlayingIndex();
    }

    private int getPlayingIndex() {
        return this.moves.size() - this.backMoves - 1;
    }

    public final synchronized HistoryItem jumpTo(HistoryItem historyItem) {
        this.setModified();
        int n = this.getPlayingIndex();
        int n2 = this.moves.indexOf(historyItem);
        if (n2 > n) {
            HistoryItem historyItem2 = this.doRedoTo(n2);
            this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n2, false);
            return historyItem2;
        }
        if (n2 < n && !historyItem.isFirstEmpty()) {
            HistoryItem historyItem3 = this.doUndoTo(n2);
            this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n2, n, false);
            return historyItem3;
        }
        return null;
    }

    public final synchronized HistoryItem doUndo() {
        this.setModified();
        int n = this.getPlayingIndex();
        int n2 = n - 1;
        HistoryItem historyItem = this.doUndoTo(n2);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n2, n, false);
        return historyItem;
    }

    private HistoryItem doUndoTo(int n) {
        if (!this.canUndoTo(n)) {
            throw new CannotUndoException();
        }
        int n2 = this.getPlayingIndex();
        for (int i = n; i <= n2; ++i) {
            HistoryItem historyItem = this.moves.get(i);
            if (!historyItem.isMove()) continue;
            historyItem.setType(HistoryItem.Type.MOVE_BACK);
        }
        this.backMoves += n2 - n;
        logger.info("back Moves:" + this.backMoves);
        return this.moves.get(n);
    }

    public final synchronized HistoryItem doRedo() {
        this.setModified();
        int n = this.getPlayingIndex();
        int n2 = n + 1;
        HistoryItem historyItem = this.doRedoTo(n2);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n2, false);
        return historyItem;
    }

    @Override
    public final synchronized void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
        this.setModified();
        int n = this.moves.size();
        if (this.game.isEditorMode() && n > 0 && !this.moves.get(n - 1).getBoard().isSideToMove(gameStatusEvent.getActiveSide())) {
            this.clearData();
        }
    }

    private HistoryItem doRedoTo(int n) {
        int n2;
        if (!this.canRedoTo(n)) {
            throw new CannotRedoException();
        }
        for (int i = n2 = this.getPlayingIndex(); i < n; ++i) {
            HistoryItem historyItem = this.moves.get(i);
            if (historyItem.getType() != HistoryItem.Type.MOVE_BACK) continue;
            historyItem.setType(HistoryItem.Type.MOVE);
        }
        this.backMoves -= n - n2;
        return this.moves.get(n);
    }

    public final synchronized HistoryItem getActiveItem() {
        return this.moves.get(this.getPlayingIndex());
    }

    public final synchronized HistoryItem jumpToFirst() {
        this.setModified();
        int n = this.firstNonEmpty();
        if (!this.canUndoTo(n)) {
            throw new CannotUndoException();
        }
        int n2 = this.getPlayingIndex();
        HistoryItem historyItem = this.doUndoTo(n);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n, n2, false);
        return historyItem;
    }

    private int firstNonEmpty() {
        return this.moves.get(0).isFirstEmpty() ? 1 : 0;
    }

    public final synchronized boolean startsBlack() {
        return this.firstNonEmpty() == 1;
    }

    public final synchronized Board getFirstBoard() {
        assert (!this.moves.isEmpty());
        return this.moves.get(this.firstNonEmpty()).getBoard();
    }

    public final synchronized HistoryItem jumpToLast() {
        this.setModified();
        int n = this.moves.size() - 1;
        if (!this.canRedoTo(n)) {
            throw new CannotRedoException();
        }
        int n2 = this.getPlayingIndex();
        HistoryItem historyItem = this.doRedoTo(n);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.UPDATE, n2, n, false);
        return historyItem;
    }

    public final synchronized List<HistoryItem> getMoveList() {
        return this.moves.subList(this.firstNonEmpty(), this.getPlayingIndex() + 1);
    }

    public final synchronized void setLoadedHistory(GameDetails gameDetails) {
        this.setModified();
        List<HistoryItem> list = gameDetails.getHistoryList();
        this.boardManager.setBoard(list.get(list.size() - 1).getBoard());
        int n = this.moves.size();
        this.moves.clear();
        this.backMoves = 0;
        if (n > 0) {
            this.fireHistoryEvent(HistoryEvent.HistoryEventType.REMOVEALL, 0, n - 1, true);
        }
        if (list.get(0).getBoard().isSideToMove(Side.BLACKS)) {
            this.moves.add(new HistoryItem());
        }
        this.moves.addAll(list);
        this.fireHistoryEvent(HistoryEvent.HistoryEventType.ADD, 0, this.moves.size() - 1, false);
    }

    private void setModified() {
        this.modified = true;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }
}

