/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.damaq.core.MainApp;
import net.damaq.core.managers.DesktopManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStyleManager;
import net.damaq.core.managers.MenuManager;
import net.damaq.core.managers.RecentFilesManager;
import net.damaq.core.managers.StatusbarManager;
import net.damaq.core.managers.ToolbarManager;
import net.damaq.core.managers.interfaces.ComponentManager;

public final class ManagerDirector
implements ComponentManager {
    private final JPanel rootContainer;
    private GameStyleManager gameStyleManager;
    private MenuManager menuManager;
    private StatusbarManager statusbarManager;
    private final JFrame mainFrame;
    private ToolbarManager toolbarManager;
    private DesktopManager desktopManager;
    private Game game;
    private RecentFilesManager recentFilesManager;

    public ManagerDirector(JFrame jFrame, JPanel jPanel) {
        this.mainFrame = jFrame;
        this.rootContainer = jPanel;
        this.init();
    }

    private void init() {
        this.gameStyleManager = new GameStyleManager();
        this.game = new Game(this.gameStyleManager);
        this.getMenuManager();
        this.recentFilesManager = new RecentFilesManager(this.getMenuManager());
        this.toolbarManager = this.getToolbarManager();
        this.rootContainer.add(this.toolbarManager.getManagerComponent(), "North");
        this.rootContainer.add(this.getDesktopManager().getManagerComponent(), "Center");
        this.rootContainer.add(this.getStatusbarManager().getManagerComponent(), "South");
    }

    public MenuManager getMenuManager() {
        return this.menuManager == null ? (this.menuManager = new MenuManager(this)) : this.menuManager;
    }

    public final JFrame getMainFrame() {
        return this.mainFrame;
    }

    public final DesktopManager getDesktopManager() {
        return this.desktopManager == null ? (this.desktopManager = new DesktopManager(this)) : this.desktopManager;
    }

    public final ToolbarManager getToolbarManager() {
        return this.toolbarManager == null ? (this.toolbarManager = new ToolbarManager()) : this.toolbarManager;
    }

    public final StatusbarManager getStatusbarManager() {
        return this.statusbarManager == null ? (this.statusbarManager = new StatusbarManager(this.getGame())) : this.statusbarManager;
    }

    public Component getManagerComponent() {
        return this.rootContainer;
    }

    public void beforeLookAndFeelUpdate() {
    }

    public GameStyleManager getGameStyleManager() {
        return this.gameStyleManager;
    }

    public void afterLookAndFeelUpdate() {
        this.getDesktopManager().lookAndFeelChanged();
    }

    public static ManagerDirector getInstance() {
        return MainApp.getInstance().getMainAppFrame().getManagerDirector();
    }

    public Game getGame() {
        return this.game;
    }

    public RecentFilesManager getRecentFilesManager() {
        return this.recentFilesManager;
    }
}

