/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.actions.BoardAction;
import net.damaq.core.actions.BoardNumbersAction;
import net.damaq.core.actions.ChangeLanguageAction;
import net.damaq.core.actions.ChangeLevelEasy;
import net.damaq.core.actions.ChangeLevelHard;
import net.damaq.core.actions.ChangeLevelLame;
import net.damaq.core.actions.ChangeLevelModerate;
import net.damaq.core.actions.CheckForNewVersion;
import net.damaq.core.actions.CompVsCompAction;
import net.damaq.core.actions.ComputerToMoveAction;
import net.damaq.core.actions.EditorModeAction;
import net.damaq.core.actions.ExitAction;
import net.damaq.core.actions.ExportDamPragueFontAction;
import net.damaq.core.actions.ExportFENBoardAction;
import net.damaq.core.actions.ExportImageBoardAction;
import net.damaq.core.actions.ExportTextBoardAction;
import net.damaq.core.actions.MoveBackAction;
import net.damaq.core.actions.MoveForwardAction;
import net.damaq.core.actions.NewGameAction;
import net.damaq.core.actions.OpenFileAction;
import net.damaq.core.actions.OpenRecentFileAction;
import net.damaq.core.actions.PasteFENAction;
import net.damaq.core.actions.PlayerToMoveAction;
import net.damaq.core.actions.PlayerVsCompAction;
import net.damaq.core.actions.PlayerVsPlayerAction;
import net.damaq.core.actions.ReversedViewAction;
import net.damaq.core.actions.SaveAsFileAction;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.actions.ShowAboutAction;
import net.damaq.core.actions.ShowAvailableMovesAction;
import net.damaq.core.actions.ShowHelpAction;
import net.damaq.core.actions.ShowHistoryAction;
import net.damaq.core.actions.ShowTimerAction;
import net.damaq.core.actions.ShowUserSettings;
import net.damaq.core.actions.ToggleStatusBarAction;
import net.damaq.core.actions.ToggleToolbarAction;
import net.damaq.core.actions.ZoomBigAction;
import net.damaq.core.actions.ZoomLargeAction;
import net.damaq.core.actions.ZoomNormalAction;
import net.damaq.core.actions.ZoomSmallAction;
import net.damaq.core.boardtools.editor.BlacksToMoveAction;
import net.damaq.core.boardtools.editor.BtnSelectBKAction;
import net.damaq.core.boardtools.editor.BtnSelectBPAction;
import net.damaq.core.boardtools.editor.BtnSelectWKAction;
import net.damaq.core.boardtools.editor.BtnSelectWPAction;
import net.damaq.core.boardtools.editor.EmptyPositionAction;
import net.damaq.core.boardtools.editor.RestoreBoardAction;
import net.damaq.core.boardtools.editor.StartingPositionAction;
import net.damaq.core.boardtools.editor.WhitesToMoveAction;
import net.damaq.core.boardtools.timer.ResetTimerAction;
import net.damaq.core.boardtools.timer.SetTimerAction;
import net.damaq.core.boardtools.timer.StartTimerAction;
import net.damaq.core.boardtools.timer.StopTimerAction;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.HistoryEvent;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.managers.SupportedLanguage;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.core.managers.interfaces.HistoryListener;
import net.damaq.core.swing.DamaqUI;
import net.damaq.core.swing.JButtonGroup;
import net.damaq.gamestyle.Side;
import net.damaq.utilities.Swinger;

public final class MenuManager
implements GameStatusListener,
HistoryListener,
PropertyChangeListener {
    private final JMenuBar menuBar = new JMenuBar();
    private JMenu gameMenu;
    private JMenu moveMenu;
    private JMenu viewMenu;
    private JMenu levelMenu;
    private JMenu boardMenu;
    private JMenu damaqMenu;
    private JMenu toolsMenu;
    private JMenu recentMenu;
    private static final String LANG_NONAME_ICON = "blank.gif";
    private JMenu zoomViewMenu;
    private final Game game;
    private JMenuItem playerVsPlayerItem;
    private JMenuItem playerVsCompItem;
    private JMenuItem compVsCompItem;

    public MenuManager(ManagerDirector managerDirector) {
        managerDirector.getMainFrame().setJMenuBar(this.menuBar);
        this.game = managerDirector.getGame();
        this.game.addGameStatusListener(this);
        this.game.getHistoryManager().addHistoryListener(this);
        this.game.getTimerManager().addPropertyChangeListener(this);
        this.updateTimerActions(this.game.getTimerManager().isRunning());
        this.menuBar.add(this.getGameMenu());
        this.menuBar.add(this.getMoveMenu());
        this.menuBar.add(this.getLevelMenu());
        this.menuBar.add(this.getBoardMenu());
        this.menuBar.add(this.getToolsMenu());
        this.menuBar.add(this.getViewMenu());
        this.menuBar.add(this.getDamaqMenu());
        MenuManager.updateLevelMenu();
    }

    private static JMenu initMenu(String string) {
        JMenu jMenu = new JMenu(Lng.getLabel("menu." + string));
        jMenu.setMnemonic(Lng.getMnemonic("menu." + string));
        return jMenu;
    }

    private Component getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = MenuManager.initMenu("view");
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            SelectableCoreAction selectableCoreAction = ToggleToolbarAction.getInstance();
            jCheckBoxMenuItem.setAction(selectableCoreAction);
            DamaqUI.setSelectable(jCheckBoxMenuItem, selectableCoreAction);
            this.viewMenu.add(jCheckBoxMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            selectableCoreAction = ToggleStatusBarAction.getInstance();
            jCheckBoxMenuItem2.setAction(selectableCoreAction);
            DamaqUI.setSelectable(jCheckBoxMenuItem2, selectableCoreAction);
            this.viewMenu.add(jCheckBoxMenuItem2);
        }
        return this.viewMenu;
    }

    private Component getBoardMenu() {
        if (this.boardMenu == null) {
            this.boardMenu = MenuManager.initMenu("board");
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            BoardAction boardAction = BoardNumbersAction.getInstance();
            jCheckBoxMenuItem.setAction(boardAction);
            DamaqUI.setSelectable(jCheckBoxMenuItem, boardAction);
            this.boardMenu.add(jCheckBoxMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            boardAction = ReversedViewAction.getInstance();
            jCheckBoxMenuItem2.setAction(boardAction);
            DamaqUI.setSelectable(jCheckBoxMenuItem2, boardAction);
            this.boardMenu.add(jCheckBoxMenuItem2);
            this.boardMenu.addSeparator();
            this.boardMenu.add(this.getZoomBoardMenu());
            this.boardMenu.addSeparator();
            JMenu jMenu = MenuManager.initMenu("board.clipboard");
            jMenu.addMenuListener(new SelectedMenuListener());
            this.boardMenu.add(jMenu);
            jMenu.setIcon(Swinger.getIcon("clipboard.gif"));
            jMenu.add(PasteFENAction.getInstance());
            jMenu.addSeparator();
            jMenu.add(ExportFENBoardAction.getInstance());
            jMenu.add(ExportTextBoardAction.getInstance());
            jMenu.add(ExportImageBoardAction.getInstance());
            jMenu.add(ExportDamPragueFontAction.getInstance());
        }
        return this.boardMenu;
    }

    private Component getLevelMenu() {
        if (this.levelMenu == null) {
            this.levelMenu = MenuManager.initMenu("level");
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            DamaqUI.setSelectable(jRadioButtonMenuItem, ChangeLevelLame.getInstance());
            this.levelMenu.add(jRadioButtonMenuItem);
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
            DamaqUI.setSelectable(jRadioButtonMenuItem2, ChangeLevelEasy.getInstance());
            this.levelMenu.add(jRadioButtonMenuItem2);
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem();
            DamaqUI.setSelectable(jRadioButtonMenuItem3, ChangeLevelModerate.getInstance());
            this.levelMenu.add(jRadioButtonMenuItem3);
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem();
            DamaqUI.setSelectable(jRadioButtonMenuItem4, ChangeLevelHard.getInstance());
            this.levelMenu.add(jRadioButtonMenuItem4);
        }
        return this.levelMenu;
    }

    private Component getDamaqMenu() {
        if (this.damaqMenu == null) {
            this.damaqMenu = MenuManager.initMenu("damaq");
            this.damaqMenu.add(new JMenuItem(new ShowHelpAction()));
            this.damaqMenu.addSeparator();
            JMenu jMenu = MenuManager.initMenu("ChangeLanguageAction");
            this.damaqMenu.add(jMenu);
            MenuManager.initLanguageMenu(jMenu);
            jMenu.setMnemonic(Lng.getMnemonic("ChangeLanguageAction"));
            this.damaqMenu.addSeparator();
            this.damaqMenu.add(new JMenuItem(ShowUserSettings.getInstance()));
            this.damaqMenu.addSeparator();
            this.damaqMenu.add(new JMenuItem(CheckForNewVersion.getInstance()));
            this.damaqMenu.addSeparator();
            this.damaqMenu.add(new JMenuItem(ShowAboutAction.getInstance()));
        }
        return this.damaqMenu;
    }

    private static void initLanguageMenu(JMenu jMenu) {
        jMenu.setIcon(Swinger.getIcon(LANG_NONAME_ICON));
        String string = Lng.getSelectedLanguageCode();
        JButtonGroup jButtonGroup = new JButtonGroup();
        for (SupportedLanguage supportedLanguage : Lng.getSupportedLanguages()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeLanguageAction(supportedLanguage));
            jButtonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(string.equals(supportedLanguage.getLanguageCode()));
        }
    }

    private Component getGameMenu() {
        if (this.gameMenu == null) {
            this.gameMenu = MenuManager.initMenu("game");
            this.gameMenu.add(new JMenuItem(NewGameAction.getInstance()));
            this.gameMenu.add(new JMenuItem(OpenFileAction.getInstance()));
            this.gameMenu.add(new JMenuItem(SaveAsFileAction.getInstance()));
            this.gameMenu.addSeparator();
            this.recentMenu = MenuManager.initMenu("file.recentFiles");
            this.gameMenu.add(this.recentMenu);
            this.recentMenu.setEnabled(false);
            this.gameMenu.addSeparator();
            this.gameMenu.add(new JMenuItem(ExitAction.getInstance()));
        }
        return this.gameMenu;
    }

    private Component getMoveMenu() {
        if (this.moveMenu == null) {
            this.moveMenu = MenuManager.initMenu("move");
            JMenuItem jMenuItem = new JMenuItem(MoveBackAction.getInstance());
            this.moveMenu.add(jMenuItem);
            this.moveMenu.add(new JMenuItem(MoveForwardAction.getInstance()));
            this.moveMenu.add(new JSeparator());
            JButtonGroup jButtonGroup = new JButtonGroup();
            this.compVsCompItem = new JRadioButtonMenuItem(CompVsCompAction.getInstance());
            DamaqUI.setSelectable(this.compVsCompItem, CompVsCompAction.getInstance());
            jButtonGroup.add(this.compVsCompItem);
            this.moveMenu.add(this.compVsCompItem);
            this.playerVsCompItem = new JRadioButtonMenuItem(PlayerVsCompAction.getInstance());
            DamaqUI.setSelectable(this.playerVsCompItem, PlayerVsCompAction.getInstance());
            jButtonGroup.add(this.playerVsCompItem);
            this.moveMenu.add(this.playerVsCompItem);
            this.playerVsPlayerItem = new JRadioButtonMenuItem(PlayerVsPlayerAction.getInstance());
            DamaqUI.setSelectable(this.playerVsPlayerItem, PlayerVsPlayerAction.getInstance());
            jButtonGroup.add(this.playerVsPlayerItem);
            this.moveMenu.add(this.playerVsPlayerItem);
            this.moveMenu.addSeparator();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ComputerToMoveAction.getInstance());
            DamaqUI.setSelectable(jRadioButtonMenuItem, ComputerToMoveAction.getInstance());
            jButtonGroup = new JButtonGroup();
            jButtonGroup.add(jRadioButtonMenuItem);
            this.moveMenu.add(jRadioButtonMenuItem);
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(PlayerToMoveAction.getInstance());
            DamaqUI.setSelectable(jRadioButtonMenuItem2, PlayerToMoveAction.getInstance());
            jButtonGroup.add(jRadioButtonMenuItem2);
            this.moveMenu.add(jRadioButtonMenuItem2);
        }
        return this.moveMenu;
    }

    private Component getToolsMenu() {
        if (this.toolsMenu == null) {
            this.toolsMenu = MenuManager.initMenu("tools");
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.toolsMenu.add(jCheckBoxMenuItem);
            DamaqUI.setSelectable(jCheckBoxMenuItem, ShowAvailableMovesAction.getInstance());
            jCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.toolsMenu.add(jCheckBoxMenuItem);
            DamaqUI.setSelectable(jCheckBoxMenuItem, ShowHistoryAction.getInstance());
            JMenu jMenu = MenuManager.initMenu("tools.timer");
            this.toolsMenu.add(jMenu);
            jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, ShowTimerAction.getInstance());
            jMenu.add(jCheckBoxMenuItem);
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(StartTimerAction.getInstance()));
            jMenu.add(new JMenuItem(StopTimerAction.getInstance()));
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(ResetTimerAction.getInstance()));
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(SetTimerAction.getInstance()));
            JMenu jMenu2 = MenuManager.initMenu("tools.editor");
            this.toolsMenu.add(jMenu2);
            jCheckBoxMenuItem = new JCheckBoxMenuItem();
            DamaqUI.setSelectable(jCheckBoxMenuItem, EditorModeAction.getInstance());
            jMenu2.add(jCheckBoxMenuItem);
            jMenu2.addSeparator();
            JButtonGroup jButtonGroup = new JButtonGroup();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, BtnSelectWPAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, BtnSelectBPAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, BtnSelectWKAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, BtnSelectBKAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jMenu2.addSeparator();
            jMenu2.add(new JMenuItem(StartingPositionAction.getInstance()));
            jMenu2.add(new JMenuItem(EmptyPositionAction.getInstance()));
            jMenu2.addSeparator();
            jButtonGroup = new JButtonGroup();
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, WhitesToMoveAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jButtonGroup.add(jRadioButtonMenuItem);
            DamaqUI.setSelectable(jRadioButtonMenuItem, BlacksToMoveAction.getInstance());
            jMenu2.add(jRadioButtonMenuItem);
            jMenu2.addSeparator();
            jMenu2.add(new JMenuItem(RestoreBoardAction.getInstance()));
        }
        return this.toolsMenu;
    }

    private JMenu getZoomBoardMenu() {
        if (this.zoomViewMenu != null) {
            return this.zoomViewMenu;
        }
        this.zoomViewMenu = MenuManager.initMenu("board.zoom");
        JButtonGroup jButtonGroup = new JButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ZoomSmallAction.getInstance());
        jButtonGroup.add(jRadioButtonMenuItem);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(ZoomNormalAction.getInstance());
        jButtonGroup.add(jRadioButtonMenuItem2);
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(ZoomBigAction.getInstance());
        jButtonGroup.add(jRadioButtonMenuItem3);
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(ZoomLargeAction.getInstance());
        jButtonGroup.add(jRadioButtonMenuItem4);
        switch (AppPrefs.getProperty("board.zoomView", 100)) {
            case 75: {
                jRadioButtonMenuItem.setSelected(true);
                break;
            }
            case 125: {
                jRadioButtonMenuItem3.setSelected(true);
                break;
            }
            case 150: {
                jRadioButtonMenuItem4.setSelected(true);
                break;
            }
            default: {
                jRadioButtonMenuItem2.setSelected(true);
            }
        }
        this.zoomViewMenu.setIcon(Swinger.getIcon("zoom.gif"));
        this.zoomViewMenu.add(jRadioButtonMenuItem);
        this.zoomViewMenu.add(jRadioButtonMenuItem2);
        this.zoomViewMenu.add(jRadioButtonMenuItem3);
        this.zoomViewMenu.add(jRadioButtonMenuItem4);
        return this.zoomViewMenu;
    }

    public void updateRecentMenu(Collection collection) {
        this.recentMenu.removeAll();
        int n = 0;
        for (File file : collection) {
            this.recentMenu.add(new JMenuItem(new OpenRecentFileAction(file, MenuManager.getMnemonicByPosition(n))));
            ++n;
        }
        this.recentMenu.setEnabled(!collection.isEmpty());
    }

    private static char getMnemonicByPosition(int n) {
        return (char)(n > 9 ? 65 + n - 10 : 48 + n);
    }

    public void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
        Side side = gameStatusEvent.getActiveSide();
        BlacksToMoveAction.getInstance().setSelected(side == Side.BLACKS);
        WhitesToMoveAction.getInstance().setSelected(side == Side.WHITES);
    }

    public void playerChanged(GameStatusEvent gameStatusEvent) {
        boolean bl;
        boolean bl2 = gameStatusEvent.getActivePlayer().isHuman();
        boolean bl3 = gameStatusEvent.getOppositePlayer().isHuman();
        PlayerVsPlayerAction.getInstance().setSelected(bl2 && bl3);
        boolean bl4 = bl = !bl2 && !bl3;
        if (bl2 && bl3) {
            this.playerVsPlayerItem.setSelected(true);
        } else if (bl) {
            this.compVsCompItem.setSelected(true);
        } else {
            this.playerVsCompItem.setSelected(true);
        }
        CompVsCompAction.getInstance().setSelected(bl);
        PlayerVsCompAction.getInstance().setSelected(!bl);
        PlayerToMoveAction.getInstance().setSelected(bl2);
        ComputerToMoveAction.getInstance().setSelected(!bl2);
    }

    public void historyFlowChanged(HistoryEvent historyEvent) {
        if (!historyEvent.isValueAdjusting()) {
            MoveBackAction.getInstance().setEnabled(this.game.getHistoryManager().canUndo());
            MoveForwardAction.getInstance().setEnabled(this.game.getHistoryManager().canRedo());
        }
    }

    public static void updateLevelMenu() {
        int n = AppPrefs.getProperty("level", 5);
        ChangeLevelLame.getInstance().setSelectedIfEqual(n);
        ChangeLevelEasy.getInstance().setSelectedIfEqual(n);
        ChangeLevelModerate.getInstance().setSelectedIfEqual(n);
        ChangeLevelHard.getInstance().setSelectedIfEqual(n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("timer")) {
            this.updateTimerActions((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    private void updateTimerActions(boolean bl) {
        StartTimerAction.getInstance().setEnabled(!bl);
        StopTimerAction.getInstance().setEnabled(bl);
    }

    private static final class SelectedMenuListener
    implements MenuListener {
        private SelectedMenuListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PasteFENAction.getInstance().updateEnable();
                }
            });
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }
    }
}

