/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import net.damaq.core.AppPrefs;
import net.damaq.core.managers.MenuManager;

public final class RecentFilesManager {
    private final MenuManager menuManager;
    private final Stack<File> recentFilesList = new Stack();
    private static final String RECENT_PREFERENCES = "recent";

    public RecentFilesManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        this.loadRecentFiles();
    }

    private static int getMaxRecentFilesSettings() {
        return AppPrefs.getProperty("recentcount", 7);
    }

    private void loadRecentFiles() {
        String string;
        String string2;
        int n = 0;
        while ((string2 = AppPrefs.getProperty(string = RECENT_PREFERENCES + n, null)) != null) {
            if (string2.length() > 0) {
                this.recentFilesList.add(0, new File(string2));
                AppPrefs.removeProperty(string);
            }
            ++n;
        }
        n = RecentFilesManager.getMaxRecentFilesSettings();
        if (this.recentFilesList.size() > n) {
            this.recentFilesList.setSize(n);
        }
        if (!this.recentFilesList.isEmpty()) {
            this.buildRecentFileMenu();
        }
    }

    public final void fileWasOpened(File file) {
        if (file == null) {
            return;
        }
        if (this.recentFilesList.indexOf(file) < 0) {
            this.recentFilesList.add(0, file);
            int n = RecentFilesManager.getMaxRecentFilesSettings();
            if (this.recentFilesList.size() > n) {
                this.recentFilesList.setSize(n);
            }
            this.buildRecentFileMenu();
        }
    }

    private void buildRecentFileMenu() {
        this.menuManager.updateRecentMenu(this.recentFilesList);
    }

    public final void removeBadFile(File file) {
        this.fileWasOpened(file);
    }

    public final void storeRecentFiles() {
        int n = this.recentFilesList.size() - 1;
        Iterator iterator = this.recentFilesList.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(RECENT_PREFERENCES + n, iterator.next().toString());
            --n;
        }
    }
}

