/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.interfaces.BoardListener;
import net.damaq.core.managers.interfaces.ComponentManager;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.core.managers.interfaces.IHidAble;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.gamestyle.Side;
import net.damaq.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatusbarManager
implements ComponentManager,
PropertyChangeListener,
IHidAble,
BoardListener,
GameStatusListener {
    private final JPanel statusPanel;
    private final Map<String, PanelItem> subSections = new LinkedHashMap<String, PanelItem>(9);
    private static final Font font = new Font("SansSerif", 0, 13);
    private final BoardManager boardManager;
    private ImageIcon computerToMoveIcon;
    private ImageIcon playerToMoveIcon;
    private ImageIcon timerOnIcon;
    private ImageIcon timerOffIcon;
    private ImageIcon workingIconOn;
    private ImageIcon workingIconOff;
    private ImageIcon whiteToMoveIcon;
    private ImageIcon blackToMoveIcon;

    public StatusbarManager(Game game) {
        game.addGameStatusListener(this);
        this.boardManager = game.getManager().getBoardManager();
        this.boardManager.addBoardChangeListener(this);
        game.getTimerManager().addPropertyChangeListener(this);
        this.statusPanel = new JPanel();
        this.statusPanel.setSize(new Dimension(10, 32));
        this.statusPanel.setPreferredSize(new Dimension(10, 32));
        this.statusPanel.setVisible(AppPrefs.getProperty("net.damaq.gui.showStatusbar", true));
        this.init();
    }

    private void init() {
        this.clear();
        TableLayout tableLayout = new TableLayout(new double[]{4.0, 115.0, 155.0, 160.0, -2.0, -2.0, -1.0, 45.0, 40.0, 4.0}, new double[]{2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        this.statusPanel.setLayout(tableLayout);
        PanelItem panelItem = this.addSection("player", "", "");
        Component component = panelItem.getManagerComponent();
        Font font = component.getFont();
        component.setFont(font.deriveFont(1));
        this.computerToMoveIcon = Swinger.getIcon("cmptomove_middle.gif");
        this.playerToMoveIcon = Swinger.getIcon("pltomove.gif");
        this.timerOnIcon = Swinger.getIcon("clock_run.gif");
        this.timerOffIcon = Swinger.getIcon("clock_stop.gif");
        this.workingIconOn = Swinger.getIcon("hourglass.gif");
        this.workingIconOff = Swinger.getIcon("hourglass_stop.gif");
        this.whiteToMoveIcon = Swinger.getIcon("white2move_big.gif");
        this.blackToMoveIcon = Swinger.getIcon("black2move_big.gif");
        this.statusPanel.add(component, new CustomLayoutConstraints(1, 1));
        this.statusPanel.add(this.addSection("color", "", Lng.getLabel("statusbar.hint.side")).getManagerComponent(), new CustomLayoutConstraints(2, 1));
        this.statusPanel.add(this.addSection("pieces", "", Lng.getLabel("statusbar.hint.gameStatus")).getManagerComponent(), new CustomLayoutConstraints(3, 1));
        this.statusPanel.add(this.addSection("timer", null, Lng.getLabel("statusbar.hint.timerOff")).getManagerComponent(), new CustomLayoutConstraints(4, 1));
        this.statusPanel.add(this.addSection("working", null, Lng.getLabel("statusbar.hint.working")).getManagerComponent(), new CustomLayoutConstraints(5, 1));
        this.statusPanel.add(this.addSection("empty", "", "").getManagerComponent(), new CustomLayoutConstraints(6, 1));
        this.statusPanel.add(this.addSection("capslock", "", Lng.getLabel("statusbar.hint.capslock")).getManagerComponent(), new CustomLayoutConstraints(7, 1));
        this.statusPanel.add(this.addSection("numlock", "", Lng.getLabel("statusbar.hint.numlock")).getManagerComponent(), new CustomLayoutConstraints(8, 1));
        this.specialKeyStatusChanged();
        this.setWorking(false);
    }

    private PanelItem addSection(String string, String string2, String string3) {
        this.removeSection(string);
        PanelItem panelItem = new PanelItem(string2, string3, false);
        this.subSections.put(string, panelItem);
        return panelItem;
    }

    private void removeSection(String string) {
        if (this.subSections.containsKey(string)) {
            this.subSections.remove(string);
        }
    }

    private void display(String string, String string2) {
        PanelItem panelItem = this.subSections.get(string);
        panelItem.setOptionalLabel(string2);
    }

    private void display(String string, ImageIcon imageIcon, String string2, String string3) {
        PanelItem panelItem = this.subSections.get(string);
        panelItem.setOptionalLabel(string2, string3);
        panelItem.setIcon(imageIcon);
    }

    private void display(String string, ImageIcon imageIcon, String string2) {
        PanelItem panelItem = this.subSections.get(string);
        panelItem.setOptionalLabel(string2, string2);
        panelItem.setIcon(imageIcon);
    }

    private void clear() {
        if (this.statusPanel != null) {
            this.statusPanel.removeAll();
            this.statusPanel.validate();
            this.statusPanel.repaint();
        }
    }

    @Override
    public void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
        if (gameStatusEvent.getActiveSide() == Side.WHITES) {
            this.display("color", this.whiteToMoveIcon, Lng.getLabel("statusbar.whitesTurn"));
        } else {
            this.display("color", this.blackToMoveIcon, Lng.getLabel("statusbar.blacksTurn"));
        }
    }

    @Override
    public void playerChanged(GameStatusEvent gameStatusEvent) {
        if (gameStatusEvent.getActivePlayer().isHuman()) {
            this.display("player", this.playerToMoveIcon, Lng.getLabel("statusbar.onMovePlayer"), Lng.getLabel("statusbar.hint.player"));
        } else {
            this.display("player", this.computerToMoveIcon, Lng.getLabel("statusbar.onMoveComp"), Lng.getLabel("statusbar.hint.computer"));
        }
    }

    @Override
    public void boardContentChanged(List<Integer> list) {
        this.updatePiecesStatus();
    }

    @Override
    public void boardChanged() {
        this.updatePiecesStatus();
    }

    private void updatePiecesStatus() {
        int[] nArray = this.boardManager.getCounts();
        this.display("pieces", Lng.getLabel("statusbar.whitesStatus", nArray[0]) + "   " + Lng.getLabel("statusbar.blacksStatus", nArray[1]));
    }

    @Override
    public final Component getManagerComponent() {
        return this.statusPanel;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("timer")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.display("timer", this.timerOnIcon, null, Lng.getLabel("statusbar.hint.timerOn"));
            } else {
                this.display("timer", this.timerOffIcon, null, Lng.getLabel("statusbar.hint.timerOff"));
            }
        }
    }

    public final void specialKeyStatusChanged() {
        this.display("capslock", StatusbarManager.getKeyStatus(20) ? Lng.getLabel("statusbar.caps") : "");
        this.display("numlock", StatusbarManager.getKeyStatus(144) ? Lng.getLabel("statusbar.num") : "");
    }

    private static boolean getKeyStatus(int n) {
        try {
            return Toolkit.getDefaultToolkit().getLockingKeyState(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    @Override
    public final boolean isVisible() {
        return this.statusPanel.isVisible();
    }

    public void setWorking(boolean bl) {
        this.display("working", bl ? this.workingIconOn : this.workingIconOff, null, Lng.getLabel("statusbar.hint.working"));
    }

    @Override
    public final void setVisible(boolean bl) {
        this.statusPanel.setVisible(bl);
        AppPrefs.storeProperty("showstatusbar", bl);
    }

    private static final class PanelItem {
        private String staticLabel = "";
        private String optionalLabel = "";
        private int length;
        private static final Border border = BorderFactory.createEtchedBorder();
        private JLabel component;
        private boolean separator = false;

        private PanelItem() {
        }

        public PanelItem(String string, String string2, boolean bl) {
            this();
            this.separator = bl;
            this.staticLabel = string;
            JLabel jLabel = new JLabel(this.getComposedText());
            if (!this.separator) {
                jLabel.setBorder(border);
            }
            jLabel.setToolTipText(string2);
            this.component = jLabel;
            jLabel.setLocation(4, 0);
            jLabel.setFont(font);
        }

        public final Component getManagerComponent() {
            return this.component;
        }

        public final int getLength() {
            return this.length;
        }

        public final String getStaticLabel() {
            return this.staticLabel;
        }

        public final void setLength(int n) {
            this.component.setSize(n, 18);
            this.length = n;
        }

        public final String getOptionalLabel() {
            return this.optionalLabel;
        }

        public final boolean isSeparator() {
            return this.separator;
        }

        public final void setOptionalLabel(String string, String string2) {
            this.optionalLabel = string;
            this.component.setText(this.getComposedText());
            this.component.setToolTipText(string2);
        }

        public final void setOptionalLabel(String string) {
            this.optionalLabel = string;
            this.component.setText(this.getComposedText());
        }

        private String getComposedText() {
            return this.getOptionalLabel() != null ? this.getStaticLabel() + " " + this.getOptionalLabel() : null;
        }

        public void setIcon(ImageIcon imageIcon) {
            this.component.setIcon(imageIcon);
            this.component.setHorizontalAlignment(10);
        }
    }
}

