/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.GameStatusEvent;
import net.damaq.core.managers.interfaces.GameStatusListener;
import net.damaq.gamestyle.Side;

public class TimeManager
implements ActionListener,
GameStatusListener {
    private Timer tickTimer = new Timer(1000, this);
    private TimeValues time;
    private final EventListenerList listenerList = new EventListenerList();
    private Side activeSide;

    public TimeManager(Game game) {
        game.addGameStatusListener(this);
        this.time = new TimeValues();
    }

    public void init() {
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.activeSide == Side.WHITES) {
            ++this.time.white;
            ++this.time.totalWhite;
        } else {
            ++this.time.black;
            ++this.time.totalBlack;
        }
        ++this.time.lastMoveTime;
        this.fireChangeEvent();
    }

    public void start() {
        this.resetOnMove();
        this.tickTimer.start();
        this.fireTimerRunStopEvent(true);
    }

    public void stop() {
        this.tickTimer.stop();
        this.fireTimerRunStopEvent(false);
    }

    public void reset() {
        this.stop();
        this.time.lastMoveTime = 0;
        this.time.totalBlack = 0;
        this.time.black = 0;
        this.time.totalWhite = 0;
        this.time.white = 0;
        this.fireChangeEvent();
    }

    public void resetOnMove() {
        if (this.activeSide == Side.WHITES) {
            this.time.white = 0;
        } else {
            this.time.black = 0;
        }
        this.time.lastMoveTime = 0;
        this.fireChangeEvent();
    }

    public void setTime(TimeValues timeValues) {
        this.time = timeValues;
        this.fireChangeEvent();
    }

    public void sideToMoveChanged(GameStatusEvent gameStatusEvent) {
        this.activeSide = gameStatusEvent.getActiveSide();
    }

    public void playerChanged(GameStatusEvent gameStatusEvent) {
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public TimeValues getTime() {
        return this.time;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    private void fireTimerRunStopEvent(boolean bl) {
        this.firePropertyEvent("timer", !bl, bl);
    }

    public boolean isRunning() {
        return this.tickTimer.isRunning();
    }

    private void firePropertyEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public static class TimeValues {
        public int black = 0;
        public int white = 0;
        public int totalBlack = 0;
        public int totalWhite = 0;
        public int lastMoveTime = 0;
    }
}

