/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.damaq.core.AppPrefs;
import net.damaq.core.actions.BoardNumbersAction;
import net.damaq.core.actions.ComputerToMoveAction;
import net.damaq.core.actions.EditorModeAction;
import net.damaq.core.actions.MoveBackAction;
import net.damaq.core.actions.MoveForwardAction;
import net.damaq.core.actions.NewGameAction;
import net.damaq.core.actions.OpenFileAction;
import net.damaq.core.actions.PlayerVsPlayerAction;
import net.damaq.core.actions.ReversedViewAction;
import net.damaq.core.actions.SaveAsFileAction;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.actions.ShowAvailableMovesAction;
import net.damaq.core.actions.ShowHistoryAction;
import net.damaq.core.actions.ShowTimerAction;
import net.damaq.core.actions.ShowUserSettings;
import net.damaq.core.managers.interfaces.ComponentManager;
import net.damaq.core.managers.interfaces.IFileChangeListener;
import net.damaq.core.managers.interfaces.IFileInstance;
import net.damaq.core.managers.interfaces.IHidAble;
import net.damaq.core.swing.DamaqUI;
import net.damaq.gui.ToolbarSeparator;
import net.damaq.utilities.Swinger;

public final class ToolbarManager
implements ComponentManager,
IFileChangeListener,
PropertyChangeListener,
IHidAble {
    private static final Logger logger = Logger.getLogger(ToolbarManager.class.getName());
    private final JPanel panel = new JPanel(new BorderLayout());
    private JToolBar toolbar;
    private static final Dimension buttonDimension = new Dimension(37, 36);

    public ToolbarManager() {
        this.panel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        UIManager.addPropertyChangeListener(this);
        this.createToolbar();
        this.panel.setVisible(AppPrefs.getProperty("showToolbar", true));
    }

    private void createToolbar() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add(this.toolbar);
        this.panel.setPreferredSize(new Dimension(400, 46));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        AbstractButton abstractButton = ToolbarManager.getButton(NewGameAction.getInstance(), "new_big.gif");
        this.toolbar.add(abstractButton);
        abstractButton = ToolbarManager.getButton(OpenFileAction.getInstance(), "open_big.gif");
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getButton(SaveAsFileAction.getInstance(), "save_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getButton(MoveBackAction.getInstance(), "undo_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getButton(MoveForwardAction.getInstance(), "redo_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getButton(ComputerToMoveAction.getInstance(), "cmptomove_big.gif");
        this.toolbar.add(abstractButton);
        abstractButton = ToolbarManager.getButton(PlayerVsPlayerAction.getInstance(), "players_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getToggleButton(BoardNumbersAction.getInstance(), "numbers_big.gif");
        this.toolbar.add(abstractButton);
        abstractButton = ToolbarManager.getToggleButton(ReversedViewAction.getInstance(), "reverse_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getToggleButton(ShowAvailableMovesAction.getInstance(), "avail_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getToggleButton(ShowTimerAction.getInstance(), "timer_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getToggleButton(ShowHistoryAction.getInstance(), "history_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getToggleButton(EditorModeAction.getInstance(), "setup_big.gif");
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(6));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(Box.createHorizontalStrut(6));
        abstractButton = ToolbarManager.getButton(ShowUserSettings.getInstance(), "options_big.gif");
        this.toolbar.add(abstractButton);
    }

    private static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction, String string) {
        JToggleButton jToggleButton = DamaqUI.getToggleButton(selectableCoreAction, buttonDimension);
        jToggleButton.setIcon(Swinger.getIcon(string));
        return jToggleButton;
    }

    private static AbstractButton getButton(Action action, String string) {
        AbstractButton abstractButton = DamaqUI.getButton(action, buttonDimension);
        abstractButton.setIcon(Swinger.getIcon(string));
        return abstractButton;
    }

    public final Component getManagerComponent() {
        return this.panel;
    }

    public void fileWasOpened(IFileInstance iFileInstance) {
    }

    public void fileWasClosed(IFileInstance iFileInstance) {
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel") && !propertyChangeEvent.getOldValue().getClass().equals(propertyChangeEvent.getNewValue().getClass())) {
            logger.info("Updating toolbar");
            this.panel.remove(this.toolbar);
            this.createToolbar();
        }
    }

    public final boolean isVisible() {
        return this.panel.isVisible();
    }

    public final void setVisible(boolean bl) {
        if (bl) {
            this.panel.setVisible(true);
        } else {
            this.panel.setVisible(false);
        }
        AppPrefs.storeProperty("showToolbar", bl);
    }
}

