/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers.player;

import net.damaq.core.managers.ManagerDirector;
import net.damaq.core.managers.StatusbarManager;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.managers.player.PlayerTask;
import net.damaq.gamestyle.Thinking;
import net.damaq.gamestyle.ThinkingStyle;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;

public final class ComputerPlayerTask
extends PlayerTask {
    private final Thinking thinking = new Thinking();

    protected final Move makeMove() {
        GameStyle gameStyle = ComputerPlayerTask.getGame().getManager().getCurrentGameStyle();
        return this.thinking.findBestMove(gameStyle, ComputerPlayerTask.getBoardManager().getBoard(), new ThinkingStyle());
    }

    public final void cancelMove() {
        super.cancelMove();
        this.thinking.stopThink();
    }

    public final Move call() throws Exception {
        TimeManager timeManager = ComputerPlayerTask.getGame().getTimerManager();
        StatusbarManager statusbarManager = ManagerDirector.getInstance().getStatusbarManager();
        statusbarManager.setWorking(true);
        timeManager.start();
        Thread.currentThread().setPriority(1);
        Move move = this.makeMove();
        timeManager.stop();
        this.doMove(ComputerPlayerTask.getDrawBoard(), move, true);
        statusbarManager.setWorking(false);
        return move;
    }
}

