/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers.player;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.managers.interfaces.MoveListener;
import net.damaq.core.managers.player.PlayerTask;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.utilities.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HumanPlayerTask
extends PlayerTask
implements MoveListener {
    private static final Logger logger = Logger.getLogger(PlayerTask.class.getName());
    private boolean threadSuspended = false;
    private final DrawBoard drawBoard = HumanPlayerTask.getDrawBoard();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Move makeMove() {
        if (this.isCanceled()) {
            return null;
        }
        logger.info("Human player, starting request move");
        this.returnMove = null;
        assert (this.drawBoard != null);
        this.drawBoard.addMoveListener(this);
        this.drawBoard.setRequestMove(true);
        try {
            HumanPlayerTask humanPlayerTask = this;
            synchronized (humanPlayerTask) {
                this.threadSuspended = true;
                while (this.threadSuspended) {
                    this.wait();
                }
            }
            logger.info("Human player, OK request move");
        }
        catch (InterruptedException interruptedException) {
            this.canceled = true;
            logger.info("Human player, cancelling request move");
        }
        if (this.isCanceled()) {
            this.drawBoard.setRequestMove(false);
        }
        this.drawBoard.removeMoveListener(this);
        return this.returnMove;
    }

    @Override
    public final void cancelMove() {
        super.cancelMove();
        assert (this.drawBoard != null);
        if (this.threadSuspended) {
            this.continueThread();
        }
    }

    @Override
    public final void onMoveStart(List<Integer> list) {
    }

    @Override
    public final void onMoveSelect(List<Integer> list) {
    }

    @Override
    public final void onMoveFinish(Move move) {
        this.returnMove = move;
        if (this.threadSuspended) {
            this.continueThread();
        }
    }

    private synchronized void continueThread() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Continue the player Thread");
        }
        this.threadSuspended = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Move call() throws Exception {
        Move move;
        TimeManager timeManager = HumanPlayerTask.getGame().getTimerManager();
        timeManager.start();
        try {
            move = this.makeMove();
        }
        catch (AssertionError assertionError) {
            LogUtils.processException(logger, (Throwable)((Object)assertionError));
            Move move2 = null;
            return move2;
        }
        finally {
            timeManager.stop();
        }
        this.doMove(this.drawBoard, move, false);
        return move;
    }
}

