/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers.player;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.managers.player.PlayerTask;
import net.damaq.damexchange.DamExchangeMsgEvent;
import net.damaq.damexchange.DamExchangeMsgListener;
import net.damaq.damexchange.messages.MoveMessage;
import net.damaq.gamestyle.NotConvertibleException;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.utilities.LogUtils;

public class InetPlayerTask
extends PlayerTask
implements DamExchangeMsgListener {
    private static final Logger logger = Logger.getLogger(InetPlayerTask.class.getName());
    private final DrawBoard drawBoard = InetPlayerTask.getDrawBoard();
    private boolean threadSuspended = false;
    private Board board;

    protected final Move makeMove() {
        return this.returnMove;
    }

    protected boolean isInetWaitingTask() {
        return true;
    }

    public void messageReceived(DamExchangeMsgEvent damExchangeMsgEvent) {
        if (!damExchangeMsgEvent.isSent() && damExchangeMsgEvent.getDamExMessage().getCode() == 'M') {
            this.convertToMove((MoveMessage)damExchangeMsgEvent.getDamExMessage());
            this.continueThread();
        }
    }

    private void convertToMove(MoveMessage moveMessage) {
        try {
            this.returnMove = InetPlayerTask.getGame().getManager().getCurrentGameStyle().newMoveInstance(this.board, moveMessage);
        }
        catch (NotConvertibleException notConvertibleException) {
            this.returnMove = null;
        }
    }

    private synchronized void continueThread() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Continue the player Thread");
        }
        this.threadSuspended = false;
        this.notify();
    }

    public final void cancelMove() {
        super.cancelMove();
        assert (this.drawBoard != null);
        if (this.threadSuspended) {
            this.continueThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Move call() throws Exception {
        Move move;
        TimeManager timeManager = InetPlayerTask.getGame().getTimerManager();
        timeManager.start();
        try {
            move = this.makeMove();
        }
        catch (AssertionError assertionError) {
            LogUtils.processException(logger, (Throwable)((Object)assertionError));
            Move move2 = null;
            return move2;
        }
        finally {
            timeManager.stop();
        }
        if (this.doMove(this.drawBoard, move, true)) {
            // empty if block
        }
        return move;
    }
}

