/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.managers.player;

import java.util.concurrent.Callable;
import net.damaq.core.boardtools.board.DrawBoard;
import net.damaq.core.managers.BoardManager;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.ManagerDirector;
import net.damaq.gamestyle.interfaces.Move;

public abstract class PlayerTask
implements Callable {
    Move returnMove = null;
    boolean canceled = false;

    protected abstract Move makeMove();

    static DrawBoard getDrawBoard() {
        return (DrawBoard)ManagerDirector.getInstance().getDesktopManager().getTool(DrawBoard.CODE);
    }

    static BoardManager getBoardManager() {
        return BoardManager.getInstance();
    }

    public void cancelMove() {
        this.canceled = true;
    }

    final boolean isCanceled() {
        return this.canceled;
    }

    protected static Game getGame() {
        return ManagerDirector.getInstance().getGame();
    }

    final boolean doMove(DrawBoard drawBoard, Move move, boolean bl) {
        if (!Thread.interrupted() && !this.isCanceled()) {
            PlayerTask.getGame().doMove(drawBoard, move, bl);
            return true;
        }
        return false;
    }
}

